<!doctype html>
<html lang="<?php echo $this->e($lang) ?>">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
	<title><?php echo $this->e($title) . ' - ' . settings('serverName') ?></title>

  <!-- alpinejs files -->
  <script defer src="https://cdn.jsdelivr.net/npm/@ryangjchandler/alpine-tooltip@1.2.0/dist/cdn.min.js"></script>
  <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.12.0/dist/cdn.min.js"></script>
  <!-- main css file -->
  <link rel="stylesheet" href="<?php echo $this->asset('/css/main.css')?>" />
  <script src="<?php echo $this->asset('/js/main.js')?>"></script>

  <?php echo $this->section('styles')?>
</head>
<body x-data="startApp()" x-cloak>
<div id="app">
  <?php echo $this->section('content') ?>
</div>

<?php echo $this->section('scripts')?>
<script src="<?php echo $this->asset('/feather-icons/feather.js')?>"></script>
<script>
    feather.replace()
</script>
</body>
</html>