<!doctype html>
<html lang="<?php echo $this->e($lang) ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo $this->e($title) . ' - ' . settings('serverName') ?></title>
    <link rel="shortcut icon" type="image/x-icon" href="/favicon.ico?cache=<?php echo settings('updatedAt') ?>">

    <!-- Translation -->
    <?php $this->insert('partials/translation_js') ?>

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo csrf_token() ?>">

    <!-- CK Editor 5 -->
    <?php if ($lang != 'en'): ?>
      <script src="<?php echo $this->asset('/js/ckeditor5/translations/'. strtolower(str_replace('_', '-', $lang)) .'.js')?>"></script>
    <?php endif; ?>
    <script src="<?php echo $this->asset('/js/ckeditor5/ckeditor.js') ?>"></script>

    <!-- Axios -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.4.0/axios.min.js"></script>

    <!-- js files -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/mdbassit/Coloris@latest/dist/coloris.min.css"/>
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
    <script src="https://cdn.jsdelivr.net/gh/mdbassit/Coloris@latest/dist/coloris.min.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/@ryangjchandler/alpine-tooltip@1.2.0/dist/cdn.min.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/@alpinejs/focus@3.x.x/dist/cdn.min.js"></script>
    <script defer src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/@alpinejs/collapse@3.12.2/dist/cdn.min.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.12.0/dist/cdn.min.js"></script>
    <script src="<?php echo $this->asset('/js/main.js')?>"></script>

    <!-- select2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- main css file -->
    <link rel="stylesheet" href="<?php echo $this->asset('/css/main.css') ?>" />

    <?php echo $this->section('styles') ?>
</head>
<body x-data="startApp()" x-cloak>
<div id="app">
	<?php $this->insert('partials/sidebar', ['category' => isset($category) ? $this->e($category) : "dashboard"]) ?>

    <main>
        <?php $this->insert('partials/header', ['breadcrumbs' => $breadcrumbs ?? []]) ?>

        <?php echo $this->section('content') ?>

        <?php $this->insert('partials/footer') ?>
    </main>
</div>

<!-- modals -->
<div id="modal-container" x-show="modal !== ''">
  <div @click="closeModal()" class="absolute inset-0 bg-black/50 backdrop-blur-[5px]"></div>
  <?php $this->insert('partials/modals') ?>

  <?php echo $this->section('custom-modals')?>
</div>

<?php $this->insert('partials/notice') ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="<?php echo $this->asset('/js/select2.js')?>"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/vanilla-lazyload/16.1.0/lazyload.min.js"></script>
<script src="<?php echo $this->asset('/js/lazyload.js')?>"></script>

<!-- flatpickr -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<?php if ($lang != 'en'): ?>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/flatpickr/4.6.13/l10n/<?php echo $lang ?>.min.js"></script>
<?php endif; ?>

<!-- featherjs -->
<script src="<?php echo $this->asset('/feather-icons/feather.js')?>"></script>
<script>
    feather.replace()
</script>

<!-- momentjs -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment-with-locales.min.js"></script>
<script>
    moment.locale('<?php echo $lang ?>');
</script>

<!-- list.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/list.js/2.3.1/list.min.js"></script>

<?php echo $this->section('scripts')?>

</body>
</html>