<?php
$this->layout('layouts/error',[
  'title' => t__('Unauthorized!')
]);
?>

<div class="center flex-col w-full">
  <i class="stroke-gray-600 w-16 h-16" data-feather="security-safe"></i>

  <h1 class="sr-only">
    <?php e__('Unauthorized!') ?>
  </h1>
  <h2 class="mt-8 text-gray-800 font-semibold"><?php echo $title ?? t__('Unauthorized Access!') ?></h2>
  <p class="text-lg text-gray-500 mt-2 max-w-sm mx-auto text-center">
    <?php echo $message ?? t__('You are not authorized to access this page!'); ?>
  </p>
  <div class="mt-10 flex gap-2">
    <a href="<?php echo url('dashboard.home'); ?>" class="btn btn-default">
      <?php e__('Back Home') ?>
    </a>
    <a href="<?php echo request()->getReferer(); ?>" class="btn btn-primary">
      <?php e__('Back') ?>
    </a>
  </div>
</div>