<?php
$this->layout('layouts/error',[
  'title' => t__('Page not found!')
]);
?>

<div class="center flex-col w-full">
  <i class="stroke-gray-600 w-16 h-16" data-feather="emoji-sad"></i>

  <h1 class="sr-only">
    <?php e__('Page not found!') ?>
  </h1>
  <h2 class="mt-8 text-gray-800 font-semibold"><?php echo t__('Page not found!') ?></h2>
  <p class="text-lg text-gray-500 mt-2 max-w-sm mx-auto text-center">
    <?php echo t__('The link you followed may be broken, or the page may have been removed!') ?>
  </p>
  <div class="mt-10 flex gap-8">
    <a href="<?php echo url('dashboard.home'); ?>" class="btn btn-primary">
      <?php e__('Back Home') ?>
    </a>
  </div>
</div>