<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.accounts.index',
        'text' => t__('Accounts')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Account'),
    'category' => 'user-management.users',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Account') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/users" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.accounts.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <form class="grid gap-4 mt-10" action="<?php echo url('dashboard.accounts.store') ?>" method="post">
		    <div class="card p-6 grid gap-4">
            <div>
                <label for="username" class="form-label">
                    <?php e__('Username') ?>
                </label>
                <input value="<?php _old('username') ?>" type="text" name="username" id="username" class="form-control">
            </div>
            <div>
                <label for="email" class="form-label">
                    <?php e__('Email') ?>
                </label>
                <input value="<?php _old('email') ?>" type="text" name="email" id="email" class="form-control">
            </div>
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-3">
              <div>
                <label for="password" class="form-label">
                  <?php e__('Password') ?>
                </label>
                <input type="password" name="password" id="password" class="form-control">
              </div>
              <div>
                <label for="passwordRe" class="form-label">
                  <?php e__('Password (Confirm)') ?>
                </label>
                <input type="password" name="passwordRe" id="passwordRe" class="form-control">
              </div>
            </div>
            <div>
                <label for="credit" class="form-label">
                    <?php e__('Credits') ?>
                </label>
                <input value="<?php _old('credit', 0) ?>" type="number" step="any" name="credit" id="credit" class="form-control">
            </div>
        </div>
		    <div class="card p-6 grid gap-4">
			    <div x-data="roles()" class="grid gap-4">
				    <div id="rolesBlock">
					    <label for="roles" class="form-label">
						    <?php e__('Roles') ?>
					    </label>
					    <select x-init="roleSelector(<?php echo htmlentities(json_encode(old('roles', []))) ?>, <?php echo htmlentities(json_encode(old('permissions', []))); ?>, '<?php echo htmlentities(old('roleDateSettings', '{}')) ?>')" name="roles[]" id="roles" multiple>
						    <?php foreach ($roles as $role): ?>
							    <option
								    value="<?php echo $role["id"] ?>"
								    data-permissions="<?php echo htmlentities(json_encode($role["permissions"])) ?>"
								    <?php _disabled($role["id"] == 1) ?>
							    >
								    <?php echo $role["name"] ?>
							    </option>
						    <?php endforeach; ?>
					    </select>
					    <input type="hidden" name="roleDateSettings" x-model="dateSettings">
				    </div>
				    
				    <div>
					    <label for="permissions" class="form-label">
						    <?php e__('Permissions') ?>
					    </label>
					    <div class="grid xl:grid-cols-4 gap-3">
						    <?php foreach ($permissions as $permission): ?>
							    <div class="flex gap-2.5 items-center">
								    <input
									    type="checkbox"
									    name="permissions[]"
									    class="form-checkbox"
									    id="permission_<?php echo $permission["id"] ?>"
									    value="<?php echo $permission["id"] ?>"
								    >
								    <label class="form-label !mb-0" for="permission_<?php echo $permission["id"] ?>">
									    <?php e__($permission["description"]) ?>
								    </label>
							    </div>
						    <?php endforeach; ?>
					    </div>
				    </div>
				    
				    <div x-show="showDateModal !== false" class="fixed inset-0" style="z-index: 999;" x-trap="showDateModal !== false">
					    <div @click="hideDateModal()" class="absolute inset-0 bg-black/50 backdrop-blur-[1px]"></div>
					    <div class="max-w-xl w-full card p-3 absolute-center -mt-20 duration-200 transition relative"
					         x-transition:enter-start="opacity-0 scale-90"
					         x-transition:enter-end="opacity-100 scale-100"
					         x-transition:leave-start="opacity-100 scale-100"
					         x-transition:leave-end="opacity-0 scale-90">
						    <div class="py-4 px-6 flex justify-between items-center">
							    <div x-text="dateSettingsModel.name" class="text-los font-medium font-maven text-xl"></div>
							    <div @click="hideDateModal()" class="cursor-pointer text-sm text-gray-400/75 transition hover:text-gray-400">
								    <svg class="w-4 fill-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
									    <path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"></path>
								    </svg>
							    </div>
						    </div>
						    <div>
							    <div class="py-4 px-6 grid gap-4">
								    <div>
									    <label for="roleDateStatus" class="form-label">
										    <?php e__('Duration Status') ?>
									    </label>
									    <select
										    x-data="select2Alpine()"
										    x-init="
                            $watch('dateSettingsModel.status', (value) => selected = value);
                            changed('roleDateStatus', () => dateSettingsModel.status = selected)
                          "
										    name="roleDateStatus"
										    id="roleDateStatus"
									    >
										    <option value="0">
											    <?php e__('Lifetime') ?>
										    </option>
										    <option value="1">
											    <?php e__('Temporary') ?>
										    </option>
									    </select>
								    </div>
								    <div x-show="dateSettingsModel.status === '1'">
									    <label for="roleDate" class="form-label">
										    <?php e__('Expiry Date') ?>
									    </label>
									    <div class="input-absolute-group">
										    <i data-feather="calendar-2"></i>
										    <input x-ref="roleDatePicker" x-model="dateSettingsModel.date" type="text" id="roleDate" name="roleDate" class="form-control" placeholder="<?php e__('Select date') ?>">
									    </div>
								    </div>
								    
								    <div class="flex justify-end gap-3 items-center">
									    <div @click="updateDate()" class="btn btn-primary">
										    <?php e__('Update') ?>
									    </div>
								    </div>
							    </div>
						    </div>
					    </div>
				    </div>
			    </div>
		    </div>
        <div class="flex justify-end">
            <?php _csrf(); ?>
            <button type="submit" class="btn btn-success">
                <?php e__('Create') ?>
            </button>
        </div>
    </form>
</section>