<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.accounts.index',
        'text' => t__('Accounts')
    ],
		[
				'url' => 'dashboard.accounts.show',
				'url_params' => [
					'id' => $account['id']
				],
				'text' => $account['realname']
		],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $account['realname']]),
    'category' => 'user-management.users',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $account['realname']]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/users" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.accounts.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>
	
		<div class="mt-10">
			<?php if (settings('allowCustomAvatars') == 1): ?>
				<div class="card p-6 mb-4">
					<div class="flex flex-col md:flex-row items-center gap-6">
						<div>
							<?php $this->insert('components/avatar', [
								'avatar' => $account['avatar'],
								'username' => $account['realname'],
								'class' => 'rounded-lg',
								'size' => '150px'
							]); ?>
							<form action="<?php echo url('dashboard.accounts.removeAvatar', ['id' => $account["id"]]); ?>" method="post" enctype="multipart/form-data" class="mt-3">
								<?php _csrf(); ?>
								<button type="submit" onclick="return confirm('<?php e__('Are you sure you want to delete?') ?>')" class="btn btn-sheer btn-danger w-full"><?php e__('Remove Avatar') ?></button>
							</form>
						</div>
						<div class="w-full mt-4 md:mt-0">
							<form action="<?php echo url('dashboard.accounts.uploadAvatar', ['id' => $account["id"]]); ?>" method="post" enctype="multipart/form-data">
								<?php _csrf(); ?>
								<label for="" class="form-label">
									<?php e__('Upload new custom avatar') ?>:
								</label>
								<label x-data="fileSelect" for="avatar" class="file-group">
									<input x-bind="fileInput" id="avatar" type="file" name="avatar" class="hidden" accept="image/png, image/gif, image/jpg, image/jpeg">
									<span class="block w-full border border-gray-200 py-2 px-4 rounded-xl cursor-pointer dark:border-gray-600/20 dark:bg-los-deep dark:text-gray-400" x-bind="textTitle('<?php e__('Choose an image') ?>')">
										<?php e__('Choose an image') ?>
									</span>
								</label>
								<div class="flex justify-end">
									<button type="submit" class="btn btn-primary mt-3"><?php e__('Upload') ?></button>
								</div>
							</form>
						</div>
					</div>
				</div>
			<?php endif; ?>
			
			<?php if (count($account['linkedAccounts']) > 0): ?>
				<div class="card p-6 grid gap-6 mb-4">
					<div class="card-title">
						<?php e__('Linked Accounts') ?>
					</div>
					<?php foreach ($account["linkedAccounts"] as $linkedAccount): ?>
						<div class="flex justify-between items-center">
							<div class="flex items-center gap-4">
								<img src="/assets/core/images/auth-providers/<?php echo $linkedAccount["slug"]; ?>.svg" alt="<?php echo $linkedAccount["name"]; ?>" width="40px">
								<div>
									<h2 class="card-title mb-0">
										<?php echo $linkedAccount["name"]; ?>
									</h2>
									<p class="text-sm text-gray-500">
										<?php
											switch ($linkedAccount["slug"]) {
												case 'discord':
													echo 'Discord ID:';
													break;
												case 'steam':
													echo 'Steam ID:';
													break;
												case 'cfx':
													echo 'Cfx.re ID:';
													break;
												case 'minecraft':
													echo 'UUID:';
													break;
												case 'roblox':
													echo 'Roblox ID:';
													break;
											}
										?>
										<?php echo $linkedAccount["identifier"] ?>
									</p>
								</div>
							</div>
							<div>
								<form action="<?php echo url('dashboard.accounts.unlinkAccount', ['id' => $account["id"], 'provider' => $linkedAccount["slug"]]) ?>" method="post">
									<?php _csrf(); ?>
									<button type="submit" class="btn btn-danger" onclick="return confirm('<?php escape_e__("Are you sure want to unlink this user's %provider% account?", ['%provider%' => $linkedAccount["name"]]) ?>');"><?php e__('Unlink') ?></button>
								</form>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			<?php endif; ?>
			
			<form class="grid gap-4" action="<?php echo url('dashboard.accounts.update', ['id' => $account['id']]); ?>" method="post">
				<div class="card p-6 grid gap-4">
					<?php _method('PATCH'); ?>
					<?php if (!moduleIsDisabled('email_verification')): ?>
						<div>
							<?php $this->insert('components/toggle', [
								'name' => 'isVerified',
								'default' => old('isVerified', $account['isVerified']),
								'labelTop' => t__('Is Email Verified?'),
							]); ?>
						</div>
					<?php endif; ?>
					<?php if (settings('loginProvider') == 'default'): ?>
						<div>
							<label for="username" class="form-label">
								<?php e__('Username') ?>
							</label>
							<input value="<?php _old('username', $account['realname']) ?>" type="text" name="username" id="username" class="form-control">
						</div>
					<?php else: ?>
						<div>
							<label for="username" class="form-label">
								<?php e__('Username') ?>
							</label>
							<input value="<?php echo $account['username'] ?>" type="text" class="form-control" readonly>
						</div>
						<div>
							<label for="username" class="form-label">
								<?php e__('Display Name') ?>
							</label>
							<input value="<?php echo $account['realname'] ?>" type="text" class="form-control" readonly>
						</div>
					<?php endif; ?>
					<div>
						<label for="email" class="form-label">
							<?php e__('Email') ?>
						</label>
						<input value="<?php _old('email', $account['email']) ?>" type="text" name="email" id="email" class="form-control">
					</div>
					<?php if (settings('loginProvider') == 'default'): ?>
						<div class="grid grid-cols-1 lg:grid-cols-2 gap-3">
							<div>
								<label for="password" class="form-label">
									<?php e__('Password') ?>
								</label>
								<input type="password" name="password" id="password" class="form-control">
							</div>
							<div>
								<label for="passwordRe" class="form-label">
									<?php e__('Password (Confirm)') ?>
								</label>
								<input type="password" name="passwordRe" id="passwordRe" class="form-control">
							</div>
						</div>
					<?php endif; ?>
					<div>
						<label for="credit" class="form-label">
							<?php e__('Credits') ?>
						</label>
						<input value="<?php _old('credit', $account['credit']) ?>" type="number" step="any" name="credit" id="credit" class="form-control">
					</div>
					
					<?php if ($account["discordUserID"]): ?>
						<!-- LEGACY DISCORD BOT -->
						<div>
							<label class="form-label">
								<?php e__('Discord User ID') ?>
							</label>
							<div class="input-absolute-group-right">
								<input value="<?php echo $account['discordUserID'] ?>" type="text" class="form-control" disabled>
								<div x-data="unlinkDiscord('<?php echo url('dashboard.accounts.unlinkDiscord', ['id' => $account["id"]]) ?>')">
									<button
										type="button"
										class="flex items-center justify-center gap-2 bg-gray-50 dark:bg-gray-200/10 text-gray-600 dark:text-white text-sm px-2.5 py-0.5 rounded-md"
										@click="unlinkDiscordRequest()"
										x-bind:disabled="isLoading"
										:class="isLoading ? 'opacity-50 pointer-events-none' : ''"
									>
										<i class="stroke-gray-600 dark:stroke-white w-4" data-feather="link-21"></i>
										<?php e__('Unlink') ?>
									</button>
								</div>
							</div>
						</div>
					<?php endif; ?>
				</div>
				
				<div class="card p-6 grid gap-4">
					<div x-data="roles()" class="grid gap-4">
						<div id="rolesBlock">
							<label for="roles" class="form-label">
								<?php e__('Roles') ?>
							</label>
							<select x-init="roleSelector(<?php echo htmlentities(json_encode(old('roles', $accountRoleIDs))) ?>, <?php echo htmlentities(json_encode(old('permissions', $accountPermissionIDs))); ?>, '<?php echo htmlentities(old('roleDateSettings', json_encode(array_column($accountRoles, 'expiryDate', 'id')))); ?>')" name="roles[]" id="roles" multiple>
								<?php foreach ($roles as $role): ?>
									<option
										value="<?php echo $role["id"] ?>"
										data-permissions="<?php echo htmlentities(json_encode($role["permissions"])) ?>"
										<?php _disabled($role["id"] == 1) ?>
									>
										<?php echo $role["name"] ?>
									</option>
								<?php endforeach; ?>
							</select>
							<input type="hidden" name="roleDateSettings" x-model="dateSettings">
						</div>
						
						<div>
							<label for="permissions" class="form-label">
								<?php e__('Permissions') ?>
							</label>
							<div class="grid xl:grid-cols-4 gap-3">
								<?php foreach ($permissions as $permission): ?>
									<div class="flex gap-2.5 items-center">
										<input
											type="checkbox"
											name="permissions[]"
											class="form-checkbox"
											id="permission_<?php echo $permission["id"] ?>"
											value="<?php echo $permission["id"] ?>"
										>
										<label class="form-label !mb-0" for="permission_<?php echo $permission["id"] ?>">
											<?php e__($permission["description"]) ?>
										</label>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
						
						<div x-show="showDateModal !== false" class="fixed inset-0" style="z-index: 999;" x-trap="showDateModal !== false">
							<div @click="hideDateModal()" class="absolute inset-0 bg-black/50 backdrop-blur-[1px]"></div>
							<div class="max-w-xl w-full card p-3 absolute-center -mt-20 duration-200 transition relative"
							     x-transition:enter-start="opacity-0 scale-90"
							     x-transition:enter-end="opacity-100 scale-100"
							     x-transition:leave-start="opacity-100 scale-100"
							     x-transition:leave-end="opacity-0 scale-90">
								<div class="py-4 px-6 flex justify-between items-center">
									<div x-text="dateSettingsModel.name" class="text-los font-medium font-maven text-xl"></div>
									<div @click="hideDateModal()" class="cursor-pointer text-sm text-gray-400/75 transition hover:text-gray-400">
										<svg class="w-4 fill-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
											<path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"></path>
										</svg>
									</div>
								</div>
								<div>
									<div class="py-4 px-6 grid gap-4">
										<div>
											<label for="roleDateStatus" class="form-label">
												<?php e__('Duration Status') ?>
											</label>
											<select
												x-data="select2Alpine()"
												x-init="
                            $watch('dateSettingsModel.status', (value) => selected = value);
                            changed('roleDateStatus', () => dateSettingsModel.status = selected)
                          "
												name="roleDateStatus"
												id="roleDateStatus"
											>
												<option value="0">
													<?php e__('Lifetime') ?>
												</option>
												<option value="1">
													<?php e__('Temporary') ?>
												</option>
											</select>
										</div>
										<div x-show="dateSettingsModel.status === '1'">
											<label for="roleDate" class="form-label">
												<?php e__('Expiry Date') ?>
											</label>
											<div class="input-absolute-group">
												<i data-feather="calendar-2"></i>
												<input x-ref="roleDatePicker" x-model="dateSettingsModel.date" type="text" id="roleDate" name="roleDate" class="form-control" placeholder="<?php e__('Select date') ?>">
											</div>
										</div>
										
										<div class="flex justify-end gap-3 items-center">
											<div @click="updateDate()" class="btn btn-primary">
												<?php e__('Update') ?>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="flex justify-end">
					<?php _csrf(); ?>
					<button type="submit" class="btn btn-success">
						<?php e__('Save Changes') ?>
					</button>
				</div>
			</form>
		</div>
</section>