<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.accounts.index',
        'text' => t__('Accounts')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Accounts'),
    'category' => 'user-management.users',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
          <?php e__('Accounts') ?>
        </h1>
        <?php if (settings('loginProvider') == 'default'): ?>
	        <a href="<?php echo url('dashboard.accounts.create') ?>" class="btn btn-primary">
		        <?php e__('Add New') ?>
	        </a>
        <?php endif; ?>
    </div>

    <?php _message(); ?>

    <div class="grid mt-10">
		    <div class="los-table-actions mb-4 grid">
			    <form method="get" action="<?php echo url('dashboard.accounts.index') ?>" class="w-full">
				    <label for="search" class="form-label">
				      <?php e__('Search for %text%', ['%text%' => t__('Accounts')]) ?>
				    </label>
				    <div class="input-absolute-group">
					    <i data-feather="search-normal"></i>
					    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
				    </div>
			    </form>
		    </div>
	      <div class="los-table">
		      <table>
			      <thead>
			      <tr>
				      <th style="width: 40px">
					      <?php e__('ID') ?>
				      </th>
				      <th>
					      <?php e__('User') ?>
				      </th>
				      <th>
								<?php e__('Email') ?>
				      </th>
				      <th>
								<?php e__('Role') ?>
				      </th>
				      <th class="!text-center">
								<?php e__('Credits') ?>
				      </th>
				      <th class="date">
								<?php e__('Date') ?>
				      </th>
				      <th>
					      <span class="sr-only">
									<?php e__('Actions') ?>
					      </span>
				      </th>
			      </tr>
			      </thead>
			      <tbody class="list">
			      <?php foreach ($accounts as $account): ?>
				      <tr>
					      <td>
						      <a href="<?php echo url('dashboard.accounts.show', ['id' => $account['id']]) ?>">#<?php echo $account['id'] ?></a>
					      </td>
					      <td>
						      <a href="<?php echo url('dashboard.accounts.show', ['id' => $account['id']]) ?>"><?php echo $account['realname'] ?></a>
						      <div>@<?php echo $account['username'] ?></div>
					      </td>
					      <td>
						      <?php echo $account['email'] ?? "-" ?>
					      </td>
					      <td>
						      <?php echo getRoles($account["id"])[0] ?>
					      </td>
					      <td class="!text-center">
						      <div><?php echo $account['credit'] ?></div>
						      <div><?php echo (moduleSettings('credit', 'creditText') != "" && moduleSettings('credit', 'creditText') != null) ? moduleSettings('credit', 'creditText') : t__('Credits') ?></div>
					      </td>
					      <td class="date">
						      <div><?php echo convertTime($account["creationDate"], 2, true) ?></div>
						      <div><?php echo convertTime($account["creationDate"]) ?></div>
					      </td>
					      <td class="table-action-buttons">
						      <div x-data="dropdown()" class="relative">
							      <div @click="toggle()" x-bind="tooltip('<?php e__('Actions') ?>')" class="btn btn-sm btn-icon btn-default border border-gray-200 dark:border-gray-600/20 dark:hover:bg-los-deep dark:hover:text-white">
								      <svg class="stroke-current stroke-2 w-4" viewBox="0 0 12 2" fill="none" xmlns="http://www.w3.org/2000/svg">
									      <path d="M9.99355 1H10.0025" stroke-linecap="round" stroke-linejoin="round"/>
									      <path d="M5.99452 1H6.00352" stroke-linecap="round" stroke-linejoin="round"/>
									      <path d="M1.9955 1H2.0045" stroke-linecap="round" stroke-linejoin="round"/>
								      </svg>
							      </div>
							      
							      <div x-bind="isDropdown" class="dropdown w-44">
								      <a href="<?php echo url('dashboard.accounts.show', ['id' => $account["id"]]) ?>">
									      <?php e__('View Account') ?>
								      </a>
								      <a href="<?php echo url('dashboard.store.credit.send.index')."?id=".$account["id"] ?>">
									      <?php e__('Send Credits') ?>
								      </a>
								      <a href="<?php echo url('dashboard.store.chest.send.index')."?id=".$account["id"] ?>">
									      <?php e__('Send Chest Item') ?>
								      </a>
								      <a href="<?php echo url('dashboard.bans.create')."?id=".$account["id"] ?>">
									      <?php e__('Ban User') ?>
								      </a>
							      </div>
						      </div>
						      
						      <a href="<?php echo url('dashboard.accounts.edit', ['id' => $account["id"]]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
							      <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
						      </a>
						      <form action="<?php echo url('dashboard.accounts.destroy', ['id' => $account['id']]) ?>" method="post" x-data="deleteConfirmation()">
							      <?php _method('DELETE'); ?>
							      <?php _csrf(); ?>
							      <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
								      <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
							      </button>
						      </form>
					      </td>
				      </tr>
			      <?php endforeach; ?>
			      </tbody>
		      </table>
	      </div>
		    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
    </div>
</section>
