<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.accounts.index',
        'text' => t__('Accounts')
    ],
    [
        'text' => t__('View')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('View Account'),
    'category' => 'user-management.users',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('View Account') ?>
        </h1>
        <a href="<?php echo url('dashboard.accounts.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <div class="mt-10">
        <div class="grid lg:grid grid-cols-1 lg:grid-cols-7 gap-8">
            <div class="lg:col-span-5 row-start-2 lg:row-start-1 flex flex-col gap-4">
                <?php if (count($statServers) > 0): ?>
                    <span class="font-medium dark:text-gray-300">
                      <?php e__('Stats') ?>
                    </span>
                    <div class="card">
                      <div class="!flex-row gap-1 !py-3 px-4 tab-container border-b border-gray-600/10">
                        <?php foreach ($statServers as $statServerTab): ?>
                          <a href="?leaderboard=<?php echo $statServerTab["serverSlug"]; ?>" class="tab-item <?php echo ($statServer && $statServerTab["serverSlug"] == $statServer["serverSlug"]) ? 'active' : null; ?>">
                            <?php echo $statServerTab["serverName"] ?>
                          </a>
                        <?php endforeach; ?>
                      </div>

                      <?php if ($statServer): ?>
	                      <?php if ($statServerUser): ?>
		                      <table class="min-w-full">
			                      <colgroup>
				                      <col style="width: 10px;">
			                      </colgroup>
			                      <thead class="">
			                      <tr class="text-xs text-center text-gray-500/80 tracking-wider bg-gray-50">
				                      <th scope="col" class="font-medium py-2 px-3 text-center">
					                      #
				                      </th>
				                      <th scope="col" class="font-medium py-2 px-3 text-left">
					                      <?php e__('Username') ?>
				                      </th>
				                      <?php foreach ($statServerTableItems as $tableTitle): ?>
					                      <th scope="col" class="font-medium py-2 px-3 text-left">
						                      <?php echo $tableTitle; ?>
					                      </th>
				                      <?php endforeach; ?>
			                      </tr>
			                      </thead>
			                      <tbody class="divide-y divide-gray-200/20 dark:divide-gray-600/10 text-center">
			                      <tr>
				                      <td class="px-3 py-4 text-center text-sm">
					                      <?php if ($statServerUserRank == 1): ?>
						                      <strong class="text-green-500">1</strong>
					                      <?php elseif ($statServerUserRank == 2): ?>
						                      <strong class="text-orange-500">2</strong>
					                      <?php elseif ($statServerUserRank == 3): ?>
						                      <strong class="text-red-500">3</strong>
					                      <?php else: ?>
						                      <span class="text-sm text-gray-500">
							                      <?php echo $statServerUserRank; ?>
						                      </span>
					                      <?php endif; ?>
				                      </td>
				                      <td class="px-3 py-4 text-left flex items-center gap-2">
					                      <p class="text-sm text-gray-500">
						                      <?php echo $account["realname"]; ?>
					                      </p>
				                      </td>
				                      <?php foreach ($statServerData as $tableData): ?>
					                      <td class="px-3 py-4 text-left">
						                      <p class="text-sm text-gray-500">
							                      <?php echo $statServerUser[$tableData]; ?>
						                      </p>
					                      </td>
				                      <?php endforeach; ?>
			                      </tr>
			                      </tbody>
		                      </table>
	                      <?php else: ?>
		                      <div class="px-5 py-4">
			                      <div class="text-red-500 text-sm">
				                      <?php e__('No data found!'); ?>
			                      </div>
		                      </div>
	                      <?php endif; ?>
                      <?php else: ?>
	                      <div class="px-5 py-4 text-center">
		                      <div class="text-gray-500 text-sm">
			                      <?php e__('Please select a leaderboard to view.'); ?>
		                      </div>
	                      </div>
                      <?php endif; ?>
                    </div>
                    <hr>
                <?php endif; ?>

                <div class="card" x-data="{show: false}">
                    <div class="py-4 px-5 flex justify-between items-center cursor-pointer" @click="show = !show">
                        <h5 class="card-title">
                            <?php e__('Orders') ?>
                        </h5>
                        <div class="cursor-pointer select-none mr-2">
                            <svg :class="{'rotate-180':show}" class="stroke-gray-400 transition rotate-180 w-3" viewBox="0 0 16 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 1.50012L8 8.50012L1 1.50012" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                    </div>
                    <div x-show="show" x-collapse class="">
                        <div class="relative" <?php echo (count($orders) > 10) ? 'style="height: 400px; overflow:auto;"' : null; ?>>
                          <table class="min-w-full">
                            <thead class="">
                            <tr class="text-xs text-center text-gray-500/80 tracking-wider bg-gray-50">
                              <th scope="col" class="font-medium py-2 px-3 text-left">
                                <?php e__('ID') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Total') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Status') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Date') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                        <span class="sr-only">
                          <?php e__('Actions') ?>
                        </span>
                              </th>
                            </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200/20 dark:divide-gray-600/10 text-center">
                            <?php if (count($orders) > 0): ?>
                              <?php foreach ($orders as $order): ?>
                                <tr>
                                  <td class="px-3 py-4 text-left">
                                    <p class="text-sm text-gray-500">#<?php echo $order["id"]; ?></p>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-700 font-medium line-clamp-2 max-w-sm block">
                                      <?php
                                      if ($order["type"] == 1) {
                                        if (moduleSettings('store', 'isCreditRequiredOnPurchase') == 1) {
                                          echo credits($order["total"]);
                                        } else {
                                          echo money($order["total"]);
                                        }
                                      } else {
                                        echo money($order["earnings"]);
                                      }
                                      ?>
                                    </div>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
                                      <?php if ($order["status"] == 1): ?>
                                        <span class="badge badge-sm badge-success"><?php e__('Success') ?></span>
                                      <?php else: ?>
                                        <span class="badge badge-sm badge-danger"><?php e__('Error') ?></span>
                                      <?php endif; ?>
                                    </div>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-700 font-medium"><?php echo convertTime($order["creationDate"], 2, true) ?></div>
                                    <div class="text-xs text-gray-500"><?php echo convertTime($order["creationDate"]) ?></div>
                                  </td>
                                  <td class="p-4 table-action-buttons">
                                    <a href="<?php echo url('dashboard.store.orders.show', ['id' => $order["id"]]); ?>" class="btn btn-sm btn-primary btn-sheer btn-icon" x-bind="tooltip('<?php e__('View') ?>')">
                                      <i class="stroke-primary-500 stroke-2 w-4" data-feather="eye"></i>
                                    </a>
                                  </td>
                                </tr>
                              <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                          </table>
                        </div>
                    </div>
                </div>

                <div class="card" x-data="{show: false}">
                    <div class="py-4 px-5 flex justify-between items-center cursor-pointer" @click="show = !show">
                        <h5 class="card-title"><?php e__('Chest') ?></h5>
                        <div class="cursor-pointer select-none mr-2">
                            <svg :class="{'rotate-180':show}" class="stroke-gray-400 transition rotate-180 w-3" viewBox="0 0 16 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 1.50012L8 8.50012L1 1.50012" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>

                        </div>
                    </div>
                    <div x-show="show" x-collapse class="">
                      <div class="relative" <?php echo (count($chests) > 10) ? 'style="height: 400px; overflow:auto;"' : null; ?>>
                        <table class="min-w-full">
                          <thead class="">
                          <tr class="text-xs text-center text-gray-500/80 tracking-wider bg-gray-50">
	                          <th scope="col" class="font-medium py-2 px-3 text-left" style="width: 40px">
		                          <?php e__('ID') ?>
	                          </th>
                            <th scope="col" class="font-medium py-2 px-3 text-left">
                              <?php e__('Product') ?>
                            </th>
                            <th scope="col" class="font-medium py-2 px-3">
                              <?php e__('Category') ?>
                            </th>
                            <th scope="col" class="font-medium py-2 px-3">
                              <?php e__('Date') ?>
                            </th>
                            <th scope="col" class="font-medium py-2 px-3">
			                        <span class="sr-only">
			                          <?php e__('Actions') ?>
			                        </span>
                            </th>
                          </tr>
                          </thead>
                          <tbody class="divide-y divide-gray-200/20 dark:divide-gray-600/10 text-center">
                          <?php if (count($chests) > 0): ?>
                            <?php foreach ($chests as $chest): ?>
                              <tr>
	                              <td class="px-3 py-4 text-left" style="width: 40px">
		                              <p class="text-xs text-gray-500">#<?php echo $chest["id"]; ?></p>
	                              </td>
                                <td class="px-3 py-4 text-left">
                                  <div class="text-sm font-medium text-gray-800"><?php echo $chest["productName"]; ?></div>
	                                <?php if (count($chest["variables"]) > 0): ?>
		                                <div class="mt-1">
			                                <?php foreach ($chest["variables"] as $variable): ?>
				                                <p class="text-xs text-gray-500">
					                                <?php echo $variable["name"] . ": " . $variable["value"]; ?>
				                                </p>
			                                <?php endforeach; ?>
		                                </div>
	                                <?php endif; ?>
                                </td>
                                <td class="px-3 py-4">
                                  <a href="<?php echo url('dashboard.store.categories.edit', ['id' => $chest['categoryID']]) ?>" class="text-sm text-gray-500 line-clamp-2 max-w-sm block" x-bind="tooltip('<?php echo str_replace(["'", '"'], ["\'", '\"'], $chest['categoryList']); ?>', 'top')">
                                    <?php echo $chest["categoryName"]; ?>
                                  </a>
                                </td>
                                <td class="px-3 py-4">
                                  <div class="text-sm text-gray-700 font-medium"><?php echo convertTime($chest["creationDate"], 2, true) ?></div>
                                  <div class="text-xs text-gray-500"><?php echo convertTime($chest["creationDate"]) ?></div>
                                </td>
                                <td class="p-4 table-action-buttons">
                                  <form action="<?php echo url('dashboard.chests.destroy', ['id' => $chest['id']]) ?>" method="post" x-data="deleteConfirmation()">
                                    <?php _method('DELETE'); ?>
                                    <?php _csrf(); ?>
                                    <button type="submit" class="btn btn-sm btn-danger btn-sheer btn-icon" x-bind="tooltip('<?php e__('Delete') ?>')">
                                      <i class="stroke-red-500 stroke-2 w-4" data-feather="trash"></i>
                                    </button>
                                  </form>
                                </td>
                              </tr>
                            <?php endforeach; ?>
                          <?php endif; ?>
                          </tbody>
                        </table>
                      </div>
                    </div>
                </div>

                <div class="card" x-data="{show: false}">
                    <div class="py-4 px-5 flex justify-between items-center cursor-pointer" @click="show = !show">
                        <h5 class="card-title">
                            <?php e__('Tickets') ?>
                        </h5>
                        <div class="cursor-pointer select-none mr-2">
                            <svg :class="{'rotate-180':show}" class="stroke-gray-400 transition rotate-180 w-3" viewBox="0 0 16 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 1.50012L8 8.50012L1 1.50012" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>

                        </div>
                    </div>
                    <div x-show="show" x-collapse class="">
                        <div class="relative" <?php echo (count($tickets) > 10) ? 'style="height: 400px; overflow:auto;"' : null; ?>>
                          <table class="min-w-full">
                            <thead class="">
                            <tr class="text-xs text-center text-gray-500/80 tracking-wider bg-gray-50">
                              <th scope="col" class="font-medium py-2 px-3 text-left">
                                <?php e__('Title') ?>/<?php e__('ID') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Category') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Last Updated') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Status') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                        <span class="sr-only">
                          <?php e__('Actions') ?>
                        </span>
                              </th>
                            </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200/20 dark:divide-gray-600/10 text-center">
                            <?php if (count($tickets) > 0): ?>
                              <?php foreach ($tickets as $ticket): ?>
                                <tr>
                                  <td class="px-3 py-4 text-left">
                                    <div class="text-sm font-medium text-gray-800"><?php echo $ticket["title"]; ?></div>
                                    <p class="text-xs text-gray-500">#<?php echo $ticket["id"]; ?></p>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block"><?php echo $ticket["categoryName"]; ?></div>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
                                      <?php if ($ticket["statusID"] == 1): ?>
                                        <span class="badge badge-sm badge-info"><?php e__("Open") ?></span>
                                      <?php elseif ($ticket["statusID"] == 2): ?>
                                        <span class="badge badge-sm badge-success"><?php e__("Answered") ?></span>
                                      <?php elseif ($ticket["statusID"] == 3): ?>
                                        <span class="badge badge-sm badge-warning"><?php e__("User-Reply") ?></span>
                                      <?php elseif ($ticket["statusID"] == 4): ?>
                                        <span class="badge badge-sm badge-danger"><?php e__("Closed") ?></span>
                                      <?php else: ?>
                                        <span class="badge badge-sm badge-danger"><?php e__("Error!") ?></span>
                                      <?php endif; ?>
                                    </div>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-700 font-medium"><?php echo convertTime($ticket["creationDate"], 2, true) ?></div>
                                    <div class="text-xs text-gray-500"><?php echo convertTime($ticket["creationDate"]) ?></div>
                                  </td>
                                  <td class="p-4 table-action-buttons">
                                    <a href="<?php echo url('dashboard.support.tickets.show', ['id' => $ticket["id"]]); ?>" class="btn btn-sm btn-primary btn-sheer btn-icon" x-bind="tooltip('<?php e__('View') ?>')">
                                      <i class="stroke-primary-500 stroke-2 w-4" data-feather="eye"></i>
                                    </a>
                                  </td>
                                </tr>
                              <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                          </table>
                        </div>
                    </div>
                </div>

                <div class="card" x-data="{show: false}">
                    <div class="py-4 px-5 flex justify-between items-center cursor-pointer" @click="show = !show">
                        <h5 class="card-title">
                            <?php e__('Credit Logs') ?>
                        </h5>
                        <div class="cursor-pointer select-none mr-2">
                            <svg :class="{'rotate-180':show}" class="stroke-gray-400 transition rotate-180 w-3" viewBox="0 0 16 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 1.50012L8 8.50012L1 1.50012" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>

                        </div>
                    </div>
                    <div x-show="show" x-collapse class="">
                      <div class="relative" <?php echo (count($creditLogs) > 10) ? 'style="height: 400px; overflow:auto;"' : null; ?>>
                        <table class="min-w-full">
                          <thead class="">
                          <tr class="text-xs text-center text-gray-500/80 tracking-wider bg-gray-50">
                            <th scope="col" class="font-medium py-2 px-3 text-left">
                              <?php e__('ID') ?>
                            </th>
                            <th scope="col" class="font-medium py-2 px-3">
                              <?php e__('Amount') ?>
                            </th>
                            <th scope="col" class="font-medium py-2 px-3">
                              <?php e__('Type') ?>
                            </th>
                            <th scope="col" class="font-medium py-2 px-3">
                              <?php e__('Date') ?>
                            </th>
                          </tr>
                          </thead>
                          <tbody class="divide-y divide-gray-200/20 dark:divide-gray-600/10 text-center">
                          <?php if (count($creditLogs) > 0): ?>
                            <?php foreach ($creditLogs as $creditLog): ?>
                              <tr>
                                <td class="px-3 py-4 text-left">
                                  <p class="text-xs text-gray-500">#<?php echo $creditLog["id"]; ?></p>
                                </td>
                                <td class="px-3 py-4">
                                  <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
                                    <?php echo ($creditLog["type"] == 1 || $creditLog["type"] == 4 || $creditLog["type"] == 6 || $creditLog["type"] == 8) ? '<span class="text-success">+' . $creditLog["price"] . '</span>' : '<span class="text-danger">-' . $creditLog["price"] . '</span>'; ?>
                                  </div>
                                </td>
                                <td class="px-3 py-4">
                                  <div class="text-sm text-gray-500 flex justify-center">
                                    <?php if ($creditLog["type"] == 1): ?>
                                      <span class="text-success flex items-center">+<i class="w-4" data-feather="coin" x-bind="tooltip('<?php e__("Charge") ?>')"></i></span>
                                    <?php elseif ($creditLog["type"] == 2): ?>
                                      <span class="text-danger flex items-center">-<i class="w-4" data-feather="coin" x-bind="tooltip('<?php e__("Usage") ?>')"></i></span>
                                    <?php elseif ($creditLog["type"] == 3): ?>
                                      <i class="w-4" data-feather="money-send" x-bind="tooltip('<?php escape_e__('Transfer to %username%', ['%username%' => $creditLog["otherAccountUsername"]]) ?>')"></i>
                                    <?php elseif ($creditLog["type"] == 4): ?>
                                      <i class="w-4" data-feather="money-send" x-bind="tooltip('<?php escape_e__('Transfer from %username%', ['%username%' => $creditLog["otherAccountUsername"]]) ?>')"></i>
                                    <?php elseif ($creditLog["type"] == 5): ?>
                                      <i class="w-4" data-feather="ticket" x-bind="tooltip('<?php e__("Wheel of Fortune (Ticket)") ?>')"></i>
                                    <?php elseif ($creditLog["type"] == 6): ?>
                                      <i class="w-4" data-feather="ticket" x-bind="tooltip('<?php e__("Wheel of Fortune (Prize)") ?>')"></i>
                                    <?php elseif ($creditLog["type"] == 7): ?>
                                      <i class="w-4" data-feather="shop" x-bind="tooltip('<?php e__("Bazaar (Purchase)") ?>')"></i>
                                    <?php elseif ($creditLog["type"] == 8): ?>
                                      <i class="w-4" data-feather="shop" x-bind="tooltip('<?php e__("Bazaar (Sell)") ?>')"></i>
                                    <?php else: ?>
                                      <i class="w-4" data-feather="money-send"></i>
                                    <?php endif; ?>
                                  </div>
                                </td>
                                <td class="px-3 py-4">
                                  <div class="text-sm text-gray-700 font-medium"><?php echo convertTime($creditLog["creationDate"], 2, true) ?></div>
                                  <div class="text-xs text-gray-500"><?php echo convertTime($creditLog["creationDate"]) ?></div>
                                </td>
                              </tr>
                            <?php endforeach; ?>
                          <?php endif; ?>
                          </tbody>
                        </table>
                      </div>
                    </div>
                </div>

                <div class="card" x-data="{show: false}">
                    <div class="py-4 px-5 flex justify-between items-center cursor-pointer" @click="show = !show">
                        <h5 class="card-title">
                            <?php e__('Wheel of Fortune Logs') ?>
                        </h5>
                        <div class="cursor-pointer select-none mr-2">
                            <svg :class="{'rotate-180':show}" class="stroke-gray-400 transition rotate-180 w-3" viewBox="0 0 16 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 1.50012L8 8.50012L1 1.50012" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>

                        </div>
                    </div>
                    <div x-show="show" x-collapse class="">
                        <div class="relative" <?php echo (count($lotteryLogs) > 10) ? 'style="height: 400px; overflow:auto;"' : null; ?>>
                          <table class="min-w-full">
                            <thead class="">
                            <tr class="text-xs text-center text-gray-500/80 tracking-wider bg-gray-50">
                              <th scope="col" class="font-medium py-2 px-3 text-left">
                                <?php e__('Wheel of Fortune') ?>/<?php e__('ID') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Prize') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Date') ?>
                              </th>
                            </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200/20 dark:divide-gray-600/10 text-center">
                            <?php if (count($lotteryLogs) > 0): ?>
                              <?php foreach ($lotteryLogs as $lotteryLog): ?>
                                <tr>
                                  <td class="px-3 py-4 text-left">
                                    <div class="text-sm font-medium text-gray-800"><?php echo $lotteryLog["lotteryTitle"]; ?></div>
                                    <p class="text-xs text-gray-500">#<?php echo $lotteryLog["id"]; ?></p>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block"><?php echo $lotteryLog["title"]; ?></div>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-700 font-medium"><?php echo convertTime($lotteryLog["creationDate"], 2, true) ?></div>
                                    <div class="text-xs text-gray-500"><?php echo convertTime($lotteryLog["creationDate"]) ?></div>
                                  </td>
                                </tr>
                              <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                          </table>
                        </div>
                    </div>
                </div>

                <div class="card" x-data="{show: false}">
                    <div class="py-4 px-5 flex justify-between items-center cursor-pointer" @click="show = !show">
                        <h5 class="card-title">
                            <?php e__('Gift Logs') ?>
                        </h5>
                        <div class="cursor-pointer select-none mr-2">
                            <svg :class="{'rotate-180':show}" class="stroke-gray-400 transition rotate-180 w-3" viewBox="0 0 16 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 1.50012L8 8.50012L1 1.50012" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>

                        </div>
                    </div>
                    <div x-show="show" x-collapse class="">
                        <div class="relative" <?php echo (count($giftLogs) > 10) ? 'style="height: 400px; overflow:auto;"' : null; ?>>
                          <table class="min-w-full">
                            <thead class="">
                            <tr class="text-xs text-center text-gray-500/80 tracking-wider bg-gray-50">
                              <th scope="col" class="font-medium py-2 px-3 text-left">
                                <?php e__('Code') ?>/<?php e__('ID') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Gift') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Date') ?>
                              </th>
                            </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200/20 dark:divide-gray-600/10 text-center">
                            <?php if (count($giftLogs) > 0): ?>
                              <?php foreach ($giftLogs as $giftLog): ?>
                                <tr>
                                  <td class="px-3 py-4 text-left">
                                    <div class="text-sm font-medium text-gray-800"><?php echo $giftLog["name"]; ?></div>
                                    <p class="text-xs text-gray-500">#<?php echo $giftLog["id"]; ?></p>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block"><?php echo $giftLog["productName"]; ?></div>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-700 font-medium"><?php echo convertTime($giftLog["creationDate"], 2, true) ?></div>
                                    <div class="text-xs text-gray-500"><?php echo convertTime($giftLog["creationDate"]) ?></div>
                                  </td>
                                </tr>
                              <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                          </table>
                        </div>
                    </div>
                </div>

                <div class="card" x-data="{show: false}">
                    <div class="py-4 px-5 flex justify-between items-center cursor-pointer" @click="show = !show">
                        <h5 class="card-title">
                            <?php e__('Chest Logs') ?>
                        </h5>
                        <div class="cursor-pointer select-none mr-2">
                            <svg :class="{'rotate-180':show}" class="stroke-gray-400 transition rotate-180 w-3" viewBox="0 0 16 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 1.50012L8 8.50012L1 1.50012" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>

                        </div>
                    </div>
                    <div x-show="show" x-collapse class="">
                        <div class="relative" <?php echo (count($chestLogs) > 10) ? 'style="height: 400px; overflow:auto;"' : null; ?>>
                          <table class="min-w-full">
                            <thead class="">
                            <tr class="text-xs text-center text-gray-500/80 tracking-wider bg-gray-50">
                              <th scope="col" class="font-medium py-2 px-3 text-left">
                                <?php e__('Product') ?>/<?php e__('ID') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Category') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Action') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Date') ?>
                              </th>
                            </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200/20 dark:divide-gray-600/10 text-center">
                            <?php if (count($chestLogs) > 0): ?>
                              <?php foreach ($chestLogs as $chestLog): ?>
                                <tr>
                                  <td class="px-3 py-4 text-left">
                                    <div class="text-sm font-medium text-gray-800"><?php echo $chestLog["productName"]; ?></div>
                                    <p class="text-xs text-gray-500">#<?php echo $chestLog["id"]; ?></p>
                                  </td>
                                  <td class="px-3 py-4">
                                    <a href="<?php echo url('dashboard.store.categories.edit', ['id' => $chestLog['categoryID']]) ?>" class="text-sm text-gray-500 line-clamp-2 max-w-sm block" x-bind="tooltip('<?php echo str_replace(["'", '"'], ["\'", '\"'], $chestLog['categoryList']); ?>', 'top')">
                                      <?php echo $chestLog["categoryName"]; ?>
                                    </a>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-500 flex justify-center">
                                      <?php if ($chestLog["type"] == 1): ?>
                                        <i class="w-5" data-feather="check" x-bind="tooltip('<?php e__("Delivery") ?>')"></i>
                                      <?php elseif ($chestLog["type"] == 2): ?>
                                        <i class="w-5" data-feather="gift" x-bind="tooltip('<?php escape_e__('Gift to %username%', ['%username%' => $chestLog["otherAccountUsername"]]) ?>')"></i>
                                      <?php elseif ($chestLog["type"] == 3): ?>
                                        <i class="w-5" data-feather="gift" x-bind="tooltip('<?php escape_e__('Gift from %username%', ['%username%' => $chestLog["otherAccountUsername"]]) ?>')"></i>
                                      <?php else: ?>
                                        <i class="w-5" data-feather="check"></i>
                                      <?php endif; ?>
                                    </div>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-700 font-medium"><?php echo convertTime($chestLog["creationDate"], 2, true) ?></div>
                                    <div class="text-xs text-gray-500"><?php echo convertTime($chestLog["creationDate"]) ?></div>
                                  </td>
                                </tr>
                              <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                          </table>
                        </div>
                    </div>
                </div>

                <div class="card" x-data="{show: false}">
                    <div class="py-4 px-5 flex justify-between items-center cursor-pointer" @click="show = !show">
                        <h5 class="card-title">
                            <?php e__('Bazaar Logs') ?>
                        </h5>
                        <div class="cursor-pointer select-none mr-2">
                            <svg :class="{'rotate-180':show}" class="stroke-gray-400 transition rotate-180 w-3" viewBox="0 0 16 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 1.50012L8 8.50012L1 1.50012" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>

                        </div>
                    </div>
                    <div x-show="show" x-collapse class="">
                        <div class="relative" <?php echo (count($bazaarLogs) > 10) ? 'style="height: 400px; overflow:auto;"' : null; ?>>
                          <table class="min-w-full">
                            <thead class="">
                            <tr class="text-xs text-center text-gray-500/80 tracking-wider bg-gray-50">
                              <th scope="col" class="font-medium py-2 px-3 text-left">
                                <?php e__('Product') ?>/<?php e__('ID') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Price') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Type') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Date') ?>
                              </th>
                            </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200/20 dark:divide-gray-600/10 text-center">
                            <?php if (count($bazaarLogs) > 0): ?>
                              <?php foreach ($bazaarLogs as $bazaarLog): ?>
                                <tr>
                                  <td class="px-3 py-4 text-left">
                                    <div class="text-sm font-medium text-gray-800"><?php echo $bazaarLog["itemName"]; ?></div>
                                    <p class="text-xs text-gray-500">#<?php echo $bazaarLog["id"]; ?></p>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
                                      <?php echo credits($bazaarLog["itemPrice"]); ?>
                                    </div>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
                                      <?php if ($bazaarLog["type"] == 0): ?>
                                        <span class="text-danger flex justify-center" x-bind="tooltip('<?php e__('Purchase') ?>')">-<i class="w-5" data-feather="coin"></i></span>
                                      <?php elseif ($bazaarLog["type"] == 1): ?>
                                        <span class="text-success flex justify-center" x-bind="tooltip('<?php e__('Sell') ?>')">+<i class="w-5" data-feather="coin"></i></span>
                                      <?php else: ?>
                                        <i data-feather="check"></i>
                                      <?php endif; ?>
                                    </div>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-700 font-medium"><?php echo convertTime($bazaarLog["creationDate"], 2, true) ?></div>
                                    <div class="text-xs text-gray-500"><?php echo convertTime($bazaarLog["creationDate"]) ?></div>
                                  </td>
                                </tr>
                              <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                          </table>
                        </div>
                    </div>
                </div>

                <div class="card" x-data="{show: false}">
                    <div class="py-4 px-5 flex justify-between items-center cursor-pointer" @click="show = !show">
                        <h5 class="card-title">
                            <?php e__('Applications') ?>
                        </h5>
                        <div class="cursor-pointer select-none mr-2">
                            <svg :class="{'rotate-180':show}" class="stroke-gray-400 transition rotate-180 w-3" viewBox="0 0 16 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 1.50012L8 8.50012L1 1.50012" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>

                        </div>
                    </div>
                    <div x-show="show" x-collapse class="">
                        <div class="relative" <?php echo (count($applications) > 10) ? 'style="height: 400px; overflow:auto;"' : null; ?>>
                          <table class="min-w-full">
                            <thead class="">
                            <tr class="text-xs text-center text-gray-500/80 tracking-wider bg-gray-50">
                              <th scope="col" class="font-medium py-2 px-3 text-left">
                                <?php e__('Form') ?>/<?php e__('ID') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Reason') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                                <?php e__('Status') ?>
                              </th>
                              <th scope="col" class="font-medium py-2 px-3">
                        <span class="sr-only">
                          <?php e__('Actions') ?>
                        </span>
                              </th>
                            </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200/20 dark:divide-gray-600/10 text-center">
                            <?php if (count($applications) > 0): ?>
                              <?php foreach ($applications as $application): ?>
                                <tr>
                                  <td class="px-3 py-4 text-left">
                                    <div class="text-sm font-medium text-gray-800"><?php echo $application["title"]; ?></div>
                                    <p class="text-xs text-gray-500">#<?php echo $application["id"]; ?></p>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
                                      <?php echo ($application["reason"] == '') ? '-' : $application["reason"]; ?>
                                    </div>
                                  </td>
                                  <td class="px-3 py-4">
                                    <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
                                      <?php if ($application["status"] == 0): ?>
                                        <span class="badge badge-sm badge-danger"><?php e__('Rejected') ?></span>
                                      <?php elseif ($application["status"] == 1): ?>
                                        <span class="badge badge-sm badge-success"><?php e__('Approved') ?></span>
                                      <?php elseif ($application["status"] == 2): ?>
                                        <span class="badge badge-sm badge-warning"><?php e__('Pending Approval') ?></span>
                                      <?php else: ?>
                                        <span class="badge badge-sm badge-danger"><?php e__('Error!') ?></span>
                                      <?php endif; ?>
                                    </div>
                                  </td>
                                  <td class="p-4 table-action-buttons">
                                    <a href="<?php echo url('dashboard.applications.show', ['id' => $application["id"]]); ?>" class="btn btn-sm btn-primary btn-sheer btn-icon" x-bind="tooltip('<?php e__('View') ?>')">
                                      <i class="stroke-primary-500 stroke-2 w-4" data-feather="eye"></i>
                                    </a>
                                  </td>
                                </tr>
                              <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                          </table>
                        </div>
                    </div>
                </div>
	            
	            <div class="card" x-data="{show: false}">
		            <div class="py-4 px-5 flex justify-between items-center cursor-pointer" @click="show = !show">
			            <h5 class="card-title">
				            <?php e__('Login Logs') ?>
			            </h5>
			            <div class="cursor-pointer select-none mr-2">
				            <svg :class="{'rotate-180':show}" class="stroke-gray-400 transition rotate-180 w-3" viewBox="0 0 16 10" fill="none" xmlns="http://www.w3.org/2000/svg">
					            <path d="M15 1.50012L8 8.50012L1 1.50012" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
				            </svg>
			            
			            </div>
		            </div>
		            <div x-show="show" x-collapse class="">
			            <div class="relative" <?php echo (count($loginLogs) > 10) ? 'style="height: 400px; overflow:auto;"' : null; ?>>
				            <table class="min-w-full">
					            <thead class="">
					            <tr class="text-xs text-center text-gray-500/80 tracking-wider bg-gray-50">
						            <th scope="col" class="!text-left font-medium py-2 px-3">
							            <?php e__('IP Address') ?>
						            </th>
						            <th scope="col" class="!text-left font-medium py-2 px-3">
							            <?php e__('Browser') ?>
						            </th>
						            <th scope="col" class="!text-left font-medium py-2 px-3">
							            OS
						            </th>
						            <th scope="col" class="font-medium py-2 px-3">
							            <?php e__('Date') ?>
						            </th>
					            </tr>
					            </thead>
					            <tbody class="divide-y divide-gray-200/20 dark:divide-gray-600/10 text-center">
					            <?php if (count($loginLogs) > 0): ?>
						            <?php foreach ($loginLogs as $loginLog): ?>
							            <tr>
								            <td class="!text-left px-3 py-4">
									            <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
										            <?php echo $loginLog["creationIP"]; ?>
									            </div>
								            </td>
								            <td class="!text-left px-3 py-4">
									            <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
										            <?php echo $loginLog["browser"]; ?>
									            </div>
								            </td>
								            <td class="!text-left px-3 py-4">
									            <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
										            <?php echo $loginLog["os"]; ?>
									            </div>
								            </td>
								            <td class="px-3 py-4">
									            <div class="text-sm text-gray-700 font-medium"><?php echo convertTime($loginLog["creationDate"], 2, true) ?></div>
									            <div class="text-xs text-gray-500"><?php echo convertTime($loginLog["creationDate"]) ?></div>
								            </td>
							            </tr>
						            <?php endforeach; ?>
					            <?php endif; ?>
					            </tbody>
				            </table>
			            </div>
		            </div>
	            </div>
            </div>
            <div class="lg:col-span-2 row-start-1 flex flex-col gap-4">
                <div class="card">
                    <div class="card-title py-4 px-5">
                        <?php e__('Profile') ?>
                    </div>
                    <div class="flex gap-5 items-center p-6 pt-2">
		                    <?php $this->insert('components/avatar', [
			                    'avatar' => $account['avatar'],
			                    'username' => $account['realname'],
			                    'class' => '!rounded-2xl',
			                    'size' => '64px'
		                    ]); ?>
                        <div class="leading-none">
                            <p class="font-semibold text-gray-800"><?php echo $account['realname'] ?></p>
                            <small class="text-sm text-gray-500">@<?php echo $account['username'] ?></small>
                            <p class="text-sm mt-2 dark:text-white">
                                <?php foreach ($account["roles"] as $accountRole): ?>
                                    <span class="badge badge-sm badge-secondary !rounded-md"><?php echo $accountRole; ?></span>
                                <?php endforeach; ?>
                            </p>
                        </div>
                    </div>
                    <div class="px-6 py-3 grid gap-2">
                        <div class="bg-gray-50 rounded-xl py-2 px-3 divide-y divide-gray-600/5">
		                        <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
			                        <span class="text-sm"><?php e__('Total Spent') ?>:</span>
			                        <span class="text-sm font-normal text-gray-500 text-right">
				                        <?php echo formatMoney($account["totalSpent"]); ?>
			                        </span>
		                        </div>
                            <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
                                <span class="text-sm"><?php e__('Credits') ?>:</span>
                                <span class="text-sm font-normal text-gray-500 text-right">
                                <?php echo formatMoney($account["credit"]); ?>
                              </span>
                            </div>
		                        <?php
			                        $providerLabels = [
				                        'discord' => 'Discord ID',
				                        'steam' => 'Steam ID',
				                        'cfx' => 'Cfx.re ID',
				                        'minecraft' => 'UUID',
				                        'roblox' => 'Roblox ID'
			                        ];
		                        ?>
		                        <?php if (settings('loginProvider') != 'default'): ?>
			                        <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
				                        <span class="text-sm"><?php echo $providerLabels[settings('loginProvider')]; ?>:</span>
				                        <span class="text-sm font-normal text-gray-500 text-right">
					                        <?php echo $account["username"]; ?>
				                        </span>
			                        </div>
		                        <?php endif; ?>
		                        <?php if ($account["email"] != null): ?>
			                        <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
				                        <span class="text-sm"><?php e__('Email') ?>:</span>
				                        <span class="text-sm font-normal text-gray-500 text-right">
					                        <?php echo $account["email"]; ?>
				                        </span>
			                        </div>
		                        <?php endif; ?>
                            <?php foreach ($accountCustomFieldValues as $accountCustomFieldValue): ?>
                                <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
                                    <span class="text-sm"><?php echo $accountCustomFieldValue["name"] ?>:</span>
                                    <span class="text-sm font-normal text-gray-500 text-right">
                                  <?php echo $accountCustomFieldValue["value"] ?>
                                </span>
                                </div>
                            <?php endforeach; ?>
                            <?php if ($siteBannedAccountStatus): ?>
                                <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
                                    <span class="text-sm"><?php e__('Ban (Website)') ?>:</span>
                                    <span class="text-sm font-normal text-gray-500 text-right">
                                  <?php echo ($siteBannedAccountStatus["expiryDate"] == '1000-01-01 00:00:00') ? t__('Lifetime') : t__('%days% day(s)', ['%days%' => getDuration($siteBannedAccountStatus["expiryDate"])]); ?>
                                </span>
                                </div>
                            <?php endif; ?>
                            <?php if ($supportBannedAccountStatus): ?>
                                <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
                                    <span class="text-sm"><?php e__('Ban (Support)') ?>:</span>
                                    <span class="text-sm font-normal text-gray-500 text-right">
                                  <?php echo ($supportBannedAccountStatus["expiryDate"] == '1000-01-01 00:00:00') ? t__('Lifetime') : t__('%days% day(s)', ['%days%' => getDuration($supportBannedAccountStatus["expiryDate"])]); ?>
                                </span>
                                </div>
                            <?php endif; ?>
                            <?php if ($commentBannedAccountStatus): ?>
                                <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
                                    <span class="text-sm"><?php e__('Ban (Comments)') ?>:</span>
                                    <span class="text-sm font-normal text-gray-500 text-right">
                                  <?php echo ($commentBannedAccountStatus["expiryDate"] == '1000-01-01 00:00:00') ? t__('Lifetime') : t__('%days% day(s)', ['%days%' => getDuration($commentBannedAccountStatus["expiryDate"])]); ?>
                                </span>
                                </div>
                            <?php endif; ?>
                            <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
                                <span class="text-sm"><?php e__('Last Seen') ?>:</span>
                                <span class="text-sm font-normal text-gray-500 text-right">
                                    <?php if (!$lastSeen): ?>
                                        -
                                    <?php else: ?>
                                        <?php echo convertTime($lastSeen["creationDate"], 2, true); ?>
                                    <?php endif; ?>
                                </span>
                            </div>
                            <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
                                <span class="text-sm"><?php e__('Reg. Date') ?>:</span>
                                <span class="text-sm font-normal text-gray-500 text-right">
                                    <?php if ($account["creationDate"] == "1000-01-01 00:00:00"): ?>
                                        -
                                    <?php else: ?>
                                        <?php echo convertTime($account["creationDate"], 2, true); ?>
                                    <?php endif; ?>
                                </span>
                            </div>
                            <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
                                <span class="text-sm"><?php e__('Reg. IP') ?>:</span>
                                <span class="text-sm font-normal text-gray-500 text-right">
                                    <?php if ($account["creationIP"] == "127.0.0.1"): ?>
                                        -
                                    <?php else: ?>
                                        <?php echo $account["creationIP"]; ?>
                                    <?php endif; ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="py-4 px-5">
                        <div class="flex flex-wrap justify-center items-center gap-2">
		                        <a href="<?php echo url('dashboard.accounts.edit', ['id' => $account["id"]]) ?>" class="col-span-2 btn btn-success center">
			                        <?php e__('Edit') ?>
		                        </a>
	                          <?php if (!moduleIsDisabled('credit')): ?>
	                            <a href="<?php echo url('dashboard.store.credit.send.index') . "?id=" . $account["id"] ?>" class="btn btn-primary text-center center">
	                                <?php e__('Send Credits') ?>
	                            </a>
	                          <?php endif; ?>
                            <?php if (!moduleIsDisabled('chest')): ?>
	                            <a href="<?php echo url('dashboard.store.chest.send.index') . "?id=" . $account["id"] ?>" class="btn btn-secondary text-center center">
		                            <?php e__('Send Chest Item') ?>
	                            </a>
                            <?php endif; ?>
                            <a href="<?php echo url('dashboard.bans.create') . "?id=" . $account["id"] ?>" class="btn btn-warning center">
                                <?php e__('Ban') ?>
                            </a>
	                        
		                        <?php if ($tfaStatus): ?>
			                        <form action="<?php echo url('dashboard.accounts.removeTfa', ['id' => $account['id']]) ?>" method="post" data-submit-loading>
				                        <?php _csrf(); ?>
				                        <button type="submit" class="btn btn-danger center">
					                        <?php e__('Remove TFA') ?>
				                        </button>
			                        </form>
		                        <?php endif; ?>

                            <form action="<?php echo url('dashboard.accounts.destroy', ['id' => $account['id']]) ?>" method="post" x-data="deleteConfirmation()">
                                <?php _method('DELETE'); ?>
                                <?php _csrf(); ?>
                                <button type="submit" class="btn btn-danger center">
                                    <?php e__('Delete') ?>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
	            
		            <?php if (count($account['linkedAccounts']) > 0): ?>
			            <div class="card p-6 grid gap-6 mb-4">
				            <div class="card-title">
					            <?php e__('Linked Accounts') ?>
				            </div>
				            <?php foreach ($account["linkedAccounts"] as $linkedAccount): ?>
					            <div class="flex justify-between items-center">
						            <div class="flex items-center gap-3">
							            <img src="/assets/core/images/auth-providers/<?php echo $linkedAccount["slug"]; ?>.svg" alt="<?php echo $linkedAccount["name"]; ?>" width="40px">
							            <div>
								            <h2 class="card-title mb-0">
									            <?php echo $linkedAccount["name"]; ?>
								            </h2>
								            <p class="text-sm text-gray-500">
									            <?php
									              switch ($linkedAccount["slug"]) {
										              case 'discord':
											              echo 'Discord ID:';
											              break;
										              case 'steam':
											              echo 'Steam ID:';
											              break;
										              case 'cfx':
											              echo 'Cfx.re ID:';
											              break;
										              case 'minecraft':
											              echo 'UUID:';
											              break;
										              case 'roblox':
											              echo 'Roblox ID:';
											              break;
									              }
									            ?>
									            <?php echo $linkedAccount["identifier"] ?>
								            </p>
							            </div>
						            </div>
						            <div>
							            <form action="<?php echo url('dashboard.accounts.unlinkAccount', ['id' => $account["id"], 'provider' => $linkedAccount["slug"]]) ?>" method="post">
								            <?php _csrf(); ?>
								            <button type="submit" class="btn btn-sm btn-icon btn-danger" onclick="return confirm('<?php escape_e__("Are you sure want to unlink this user's %provider% account?", ['%provider%' => $linkedAccount["name"]]) ?>');" x-bind="tooltip('<?php e__('Unlink') ?>')"">
									            <i data-feather="x" class="stroke-white stroke-2 w-4"></i>
								            </button>
							            </form>
						            </div>
					            </div>
				            <?php endforeach; ?>
			            </div>
		            <?php endif; ?>
            </div>
        </div>
    </div>
</section>