<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.accounts.index',
        'text' => t__('Accounts')
    ],
    [
        'text' => t__('Staff')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Staff'),
    'category' => 'user-management.staff',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Staff') ?>
        </h1>
		    <?php if (settings('loginProvider') == 'default'): ?>
			    <a href="<?php echo url('dashboard.accounts.create') ?>" class="btn btn-primary">
			        <?php e__('Add New') ?>
			    </a>
		    <?php endif; ?>
    </div>
	
		<div x-data="listjs()" id="listjs" class="grid mt-10">
			<div class="los-table-actions mb-4 grid">
				<div class="w-full">
					<label for="search" class="form-label">
						<?php e__('Search for %text%', ['%text%' => t__('Staff')]) ?>
					</label>
					<div class="input-absolute-group">
						<i data-feather="search-normal"></i>
						<input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					</div>
				</div>
			</div>
			<div class="los-table">
				<table>
					<thead>
					<tr>
						<th style="width: 40px">
							<div class="sort" data-sort="user_id">
								<?php e__('ID') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="username">
								<?php e__('User') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="email">
								<?php e__('Email') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="roles">
								<?php e__('Role') ?>
							</div>
						</th>
						<th>
							<div class="sort center" data-sort="credits">
								<?php e__('Credits') ?>
							</div>
						</th>
						<th>
							<div class="sort center" data-sort="date">
								<?php e__('Date') ?>
							</div>
						</th>
						<th>
							<span class="sr-only">
								<?php e__('Actions') ?>
							</span>
						</th>
					</tr>
					</thead>
					<tbody class="list">
					<?php foreach ($accounts as $account): ?>
						<tr>
							<td>
								<a class="user_id" href="<?php echo url('dashboard.accounts.show', ['id' => $account['id']]) ?>">#<?php echo $account['id'] ?></a>
							</td>
							<td>
								<a class="username" href="<?php echo url('dashboard.accounts.show', ['id' => $account['id']]) ?>"><?php echo $account['realname'] ?></a>
								<div>@<?php echo $account['username'] ?></div>
							</td>
							<td class="email">
								<?php echo $account['email'] ?>
							</td>
							<td class="roles">
								<?php echo $account["roles"] ?>
							</td>
							<td class="center">
								<div class="credits"><?php echo $account['credit'] ?></div>
								<div><?php echo (moduleSettings('credit', 'creditText') != "" && moduleSettings('credit', 'creditText') != null) ? moduleSettings('credit', 'creditText') : t__('Credits') ?></div>
							</td>
							<td class="date">
								<div><?php echo convertTime($account["creationDate"], 2, true) ?></div>
								<div><?php echo convertTime($account["creationDate"]) ?></div>
							</td>
							<td class="table-action-buttons">
								<a href="<?php echo url('dashboard.accounts.show', ['id' => $account["id"]]) ?>" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									<i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								</a>
								<a href="<?php echo url('dashboard.accounts.edit', ['id' => $account["id"]]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									<i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								</a>
							</td>
						</tr>
					<?php endforeach; ?>
					</tbody>
				</table>
			</div>
		</div>
</section>
