<?php
	$breadcrumbs = [
		[
			'url' => 'dashboard.ai.index',
			'text' => t__('AI')
		],
		[
			'text' => t__('Data Sources')
		]
	];
	$this->layout('layouts/main', [
		'title' => t__('AI'),
		'category' => 'misc.ai.data',
		'breadcrumbs' => $breadcrumbs
	]) ?>

<section class="los-container tight-container py-9">
	<div class="los-page-heading">
		<h1 class="text-gray-950">
			<?php e__('Data Sources') ?>
		</h1>
	</div>
	
	<?php _message(); ?>
	
	<div class="mt-10">
		<?php if ($subscription["plan"]["limits"]["data_sources"] > $subscription["usage"]["data_sources"]): ?>
			<div class="card p-6">
				<form method="post" enctype="multipart/form-data" action="<?php echo url('dashboard.ai.data.process') ?>" class="grid gap-4" x-data="{dataSourceType: '<?php _old('dataSourceType', 'file') ?>', fileName: ''}" data-submit-loading>
					<div>
						<label for="dataSourceType" class="form-label">
							<?php e__('Data Source Type') ?>
						</label>
						<fieldset aria-label="Choose a data source type">
							<div class="grid grid-cols-4 gap-3 sm:grid-cols-8">
								<label :class="{'small-radio-card': true, 'active': dataSourceType === 'file'}">
									<input type="radio" name="dataSourceType" value="file" class="sr-only" x-model="dataSourceType">
									<span>
									<?php e__('File') ?>
								</span>
								</label>
								<label :class="{'small-radio-card': true, 'active': dataSourceType === 'sitemap'}">
									<input type="radio" name="dataSourceType" value="sitemap" class="sr-only" x-model="dataSourceType">
									<span>
									<?php e__('Sitemap') ?>
								</span>
								</label>
							</div>
						</fieldset>
					</div>
					
					<div x-show="dataSourceType === 'file'">
						<div
								x-show="dataSourceType === 'file'"
								class="flex flex-col items-center justify-center border-2 border-dashed border-gray-600/20 rounded-lg p-8 transition-colors cursor-pointer hover:border-gray-600/50 relative group "
								@dragover.prevent
								@dragenter.prevent="isDragging = true"
								@dragleave.prevent="isDragging = false"
								@drop.prevent="
								    isDragging = false;
								    $refs.fileInput.files = $event.dataTransfer.files;
								    fileName = $event.dataTransfer.files[0]?.name || '';
								"
								@click="$refs.fileInput.click()"
								x-data="{ isDragging: false }"
								:class="{'border-blue-500 bg-blue-500/10': isDragging}"
						>
							<input
									type="file"
									name="file"
									x-ref="fileInput"
									class="hidden"
									accept=".pdf,.csv,.txt,.xlsx,.md,.mdx,.xml,.json,.docx"
									@change="isDragging = false; fileName = $refs.fileInput.files[0].name;"
									maxsize="10485760"
							>
							<svg xmlns="http://www.w3.org/2000/svg" class="w-12 h-12 text-gray-400 mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
								<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v2a2 2 0 002 2h12a2 2 0 002-2v-2M7 10l5-5m0 0l5 5m-5-5v12" />
							</svg>
							<div class="text-center">
								<span class="block text-gray-400 font-medium mb-1"><?php e__('Drag your file here or click to browse.') ?></span>
								<span x-show="fileName !== ''" class="block text-gray-700 font-medium mt-2" x-text="fileName"></span>
							</div>
						</div>
						<div class="flex justify-center lg:justify-between flex-col lg:flex-row items-center mt-4 text-gray-400 dark:text-gray-500 text-sm">
							<div>
								<?php e__('Supported formats: %formats%', ['%formats%' => 'pdf, csv, txt, xlsx, md, xml, json, docx']) ?>
							</div>
							<div class="mt-2 lg:mt-0">
								<?php e__('Maximum size: %size%', ['%size%' => '10MB']) ?>
							</div>
						</div>
					</div>
					
					<div x-show="dataSourceType === 'sitemap'">
						<input value="<?php _old('sitemapUrl') ?>" type="text" id="sitemapUrl" name="sitemapUrl" class="form-control" placeholder="<?php e__('Enter a Sitemap URL') ?>">
					</div>
					
					<div class="flex justify-end mt-4">
						<?php _csrf(); ?>
						<button type="submit" class="btn btn-success"><?php e__('Add') ?></button>
					</div>
				</form>
			</div>
		<?php else: ?>
			<div class="card p-6">
				<div class="text-center">
					<div class="flex center mb-4">
						<i class="w-16 h-16 stroke-gray-600" data-feather="lock"></i>
					</div>
					
					<h3 class="text-gray-800 mb-4">
						<?php e__('You have reached your data source limit!') ?>
					</h3>
					<p class="text-gray-600 mb-6">
						<?php e__('To add more data sources, please upgrade your plan or remove existing data sources.') ?>
					</p>
					<a href="<?php echo LOCATION === 'TR' ? 'https://www.leaderos.com.tr/hesap/ai' : 'https://www.leaderos.net/account/ai' ?>" target="_blank" class="btn btn-primary">
						<?php e__('Upgrade Plan') ?>
					</a>
				</div>
			</div>
		<?php endif; ?>
		
		<?php if (count($dataSources) > 0): ?>
			<div x-data="listjs()" id="listjs" class="grid mt-10">
				<div class="los-table">
					<table>
						<thead>
						<tr>
							<th>
								<div class="sort" data-sort="name">
									<?php e__('Data Source') ?>
								</div>
							</th>
							<th>
								<div class="sort" data-sort="type">
									<?php e__('Type') ?>
								</div>
							</th>
							<th>
								<div class="sort" data-sort="status">
									<?php e__('Status') ?>
								</div>
							</th>
							<th>
					    <span class="sr-only">
						    <?php e__('Actions') ?>
					    </span>
							</th>
						</tr>
						</thead>
						<tbody class="list">
						<?php foreach ($dataSources as $dataSource): ?>
							<tr>
								<td class="name">
									<?php echo $dataSource['name'] ?>
								</td>
								<td class="type">
									<?php echo $dataSource['type'] ?>
								</td>
								<td class="status">
									<?php if ($dataSource["status"] == 'completed'): ?>
										<span class="badge badge-soft-success">
										<?php e__('Completed') ?>
									</span>
									<?php endif; ?>
									<?php if ($dataSource["status"] == 'failed'): ?>
										<span class="badge badge-soft-danger">
										<?php e__('Failed') ?>
									</span>
									<?php endif; ?>
									<?php if ($dataSource["status"] == 'in_progress'): ?>
										<div class="badge badge-soft-primary">
											<svg class="mr-2 -ml-1 w-4 h-4 animate-spin text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
												<circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
												<path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
											</svg>
											<?php e__('In Progress') ?>
										</div>
									<?php endif; ?>
								</td>
								<td class="table-action-buttons">
									<?php if ($dataSource["status"] !== 'in_progress'): ?>
										<form action="<?php echo url('dashboard.ai.data.destroy', ['id' => $dataSource['id']]) ?>" method="post" x-data="deleteConfirmation()">
											<?php _method('DELETE'); ?>
											<?php _csrf(); ?>
											<button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
												<i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
											</button>
										</form>
									<?php endif; ?>
								</td>
							</tr>
						<?php endforeach; ?>
						</tbody>
					</table>
				</div>
			</div>
		<?php endif; ?>
	</div>
</section>
