<?php
	$breadcrumbs = [
		[
			'url' => 'dashboard.ai.index',
			'text' => t__('AI')
		]
	];
	$this->layout('layouts/main', [
		'title' => t__('AI'),
		'category' => 'misc.ai.index',
		'breadcrumbs' => $breadcrumbs
	]) ?>

	<section class="los-container tight-container py-9">
		<div class="los-page-heading">
			<h1 class="text-gray-950">
				<?php e__('Overview') ?>
			</h1>
		</div>
		
		<div class="mt-10">
			<div class="mb-8">
				<div class="div flex justify-between items-center">
					<h4 class="text-gray-800">
						<?php e__('Current Plan') ?>
					</h4>
					<a href="<?php echo LOCATION === 'TR' ? 'https://www.leaderos.com.tr/hesap/ai/yonet/' . $subscription["id"] : 'https://www.leaderos.net/account/ai/manage/' . $subscription["id"] ?>" target="_blank" class="btn btn-dark">
						<?php e__('Manage Plan') ?>
					</a>
				</div>
				<div class="mt-4 grid xl:grid-cols-2 gap-6">
					<div class="card p-6">
						<div class="flex justify-between items-center">
							<div>
								<h5 class="card-title">
									<?php e__('Plan') ?>
								</h5>
								<div class="flex items-center gap-1">
									<span class="h3 text-gray-950">
										<?php if ($subscription["plan"]["id"] == 1): ?>
											<?php e__($subscription["plan"]["name"]) ?>
										<?php else: ?>
											<?php echo $subscription["plan"]["name"] ?>
										<?php endif; ?>
									</span>
									<?php if ($subscription["next_plan"] !== null): ?>
										<svg x-bind="tooltip('<?php e__('Your plan will change to %plan% on %date%.', ['%plan%' => $subscription["next_plan"]["name"], '%date%' => convertTime($subscription["ends_at"], 1)]) ?>')" class="ml-1 text-gray-950 opacity-70 w-4 h-4" fill="currentColor" aria-hidden="true" width="12" height="12" viewBox="0 0 12 12" xmlns="http://www.w3.org/2000/svg">
											<path fill-rule="evenodd" clip-rule="evenodd" d="M8.75 1.75h-5.5a1.5 1.5 0 0 0-1.5 1.5v5.5a1.5 1.5 0 0 0 1.5 1.5h5.5a1.5 1.5 0 0 0 1.5-1.5v-5.5a1.5 1.5 0 0 0-1.5-1.5ZM3.25.25a3 3 0 0 0-3 3v5.5a3 3 0 0 0 3 3h5.5a3 3 0 0 0 3-3v-5.5a3 3 0 0 0-3-3h-5.5Z"></path>
											<path fill-rule="evenodd" clip-rule="evenodd" d="M4.482 6.5a.7.7 0 0 1 .7-.7h1.09a.7.7 0 0 1 .7.7v2a.7.7 0 1 1-1.4 0V7.2h-.39a.7.7 0 0 1-.7-.7Z"></path>
											<path d="M5 4a1.001 1.001 0 0 1 2 0 1.001 1.001 0 0 1-2 0Z"></path>
										</svg>
									<?php endif; ?>
								</div>
							</div>
							<div>
								<?php if ($subscription["status"] == 'active'): ?>
									<div class="badge badge-lg badge-soft-success">
										<?php e__('Active') ?>
										
										<?php if ($subscription["cancel_at_period_end"]): ?>
												<svg x-bind="tooltip('<?php e__('Cancels %date%', ['%date%' => convertTime($subscription["ends_at"], 1)]) ?>')" class="ml-1" fill="currentColor" aria-hidden="true" width="12" height="12" viewBox="0 0 12 12" xmlns="http://www.w3.org/2000/svg">
													<path fill-rule="evenodd" clip-rule="evenodd" d="M8.75 1.75h-5.5a1.5 1.5 0 0 0-1.5 1.5v5.5a1.5 1.5 0 0 0 1.5 1.5h5.5a1.5 1.5 0 0 0 1.5-1.5v-5.5a1.5 1.5 0 0 0-1.5-1.5ZM3.25.25a3 3 0 0 0-3 3v5.5a3 3 0 0 0 3 3h5.5a3 3 0 0 0 3-3v-5.5a3 3 0 0 0-3-3h-5.5Z"></path>
													<path fill-rule="evenodd" clip-rule="evenodd" d="M4.482 6.5a.7.7 0 0 1 .7-.7h1.09a.7.7 0 0 1 .7.7v2a.7.7 0 1 1-1.4 0V7.2h-.39a.7.7 0 0 1-.7-.7Z"></path>
													<path d="M5 4a1.001 1.001 0 0 1 2 0 1.001 1.001 0 0 1-2 0Z"></path>
												</svg>
										<?php endif; ?>
									</div>
								<?php endif; ?>
								<?php if ($subscription["status"] == 'unpaid'): ?>
									<div class="badge badge-lg badge-soft-warning">
										<?php e__('Unpaid') ?>
									</div>
								<?php endif; ?>
								<?php if ($subscription["status"] == 'expired'): ?>
									<div class="badge badge-lg badge-soft-warning">
										<?php e__('Expired') ?>
									</div>
								<?php endif; ?>
								<?php if ($subscription["status"] == 'canceled'): ?>
									<div class="badge badge-lg badge-soft-danger">
										<?php e__('Canceled') ?>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
					
					<div class="card p-6">
						<h5 class="card-title">
							<?php if ($subscription["status"] == "canceled" || $subscription["status"] == "expired"): ?>
								<?php e__('Ended at') ?>
					    <?php else: ?>
								<?php if ($subscription["cancel_at_period_end"]): ?>
									<?php e__('Scheduled to cancel on') ?>
								<?php else: ?>
									<?php e__('Next Billing Date') ?>
								<?php endif; ?>
							<?php endif; ?>
						</h5>
						<div>
							<span class="h3 text-gray-950">
								<?php echo convertTime($subscription["ends_at"], 1, false); ?>
							</span>
						</div>
					</div>
				</div>
			</div>
			
			<div class="mb-6">
				<h4 class="text-gray-800">
					<?php e__('Usage') ?>
				</h4>
				<div class="mt-4 grid xl:grid-cols-2 gap-6">
					<?php $this->insert('components/ai/usage-card', [
						'title' => t__('Auto-Reply to Support Tickets'),
						'usage' => $subscription["usage"]["auto_ticket_reply"],
						'limit' => $subscription["plan"]["limits"]["auto_ticket_reply"]
					]) ?>
					
					<?php $this->insert('components/ai/usage-card', [
						'title' => t__('In-Game /ai command usage'),
						'usage' => $subscription["usage"]["ingame_ai_command"],
						'limit' => $subscription["plan"]["limits"]["ingame_ai_command"]
					]) ?>
					
					<?php $this->insert('components/ai/usage-card', [
						'title' => t__('Discord /ai command usage'),
						'usage' => $subscription["usage"]["discord_ai_command"],
						'limit' => $subscription["plan"]["limits"]["discord_ai_command"]
					]) ?>
					
					<?php $this->insert('components/ai/usage-card', [
						'title' => t__('Generate with AI'),
						'usage' => $subscription["usage"]["generate_with_ai"],
						'limit' => $subscription["plan"]["limits"]["generate_with_ai"]
					]) ?>
					
					<?php $this->insert('components/ai/usage-card', [
						'title' => t__('Data Sources'),
						'usage' => $subscription["usage"]["data_sources"],
						'limit' => $subscription["plan"]["limits"]["data_sources"]
					]) ?>
				</div>
			</div>
		</div>
	</section>
