<?php
	$breadcrumbs = [
		[
			'url' => 'dashboard.settings.index',
			'text' => t__('Settings')
		],
		[
			'text' => t__('AI')
		]
	];
	$this->layout('layouts/main', [
		'title' => t__('%module% Settings', ['%module%' => t__('AI')]),
		'category' => 'misc.ai.settings',
		'breadcrumbs' => $breadcrumbs
	]) ?>

<section class="los-container tight-container py-9">
	<div class="los-page-heading">
		<h1 class="text-gray-950"><?php e__('%module% Settings', ['%module%' => t__('AI')]) ?></h1>
		<a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
			<?php e__('Back') ?>
		</a>
	</div>
	
	<?php _message(); ?>
	
	<form action="<?php echo url('dashboard.ai.settings.update') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
		<?php _method('PATCH'); ?>
		<div class="mt-10 card p-6 grid gap-4">
			<div>
				<label for="name" class="form-label">
					<?php e__('AI Assistant Name') ?>
				</label>
				<input value="<?php _old('name', moduleSettings('ai', 'name')) ?>" type="text" id="name" name="name" class="form-control">
			</div>
			<div>
				<?php $this->insert('components/toggle', [
					'name' => 'autoReply',
					'default' => old('autoReply', moduleSettings('ai', 'autoReply')) == '0' ? '0' : '1',
					'labelRight' => t__('Enable auto reply to support tickets.'),
				]); ?>
			</div>
		</div>
		<div class="flex justify-end">
			<?php _csrf(); ?>
			<button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
		</div>
	</form>
</section>