<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.announcements.index',
        'text' => t__('Announcements')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Add an Announcement'),
    'category' => 'misc.announcements',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Announcement') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/announcements" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.announcements.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.announcements.create') ?>" method="post" class="grid gap-4">
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('title') ?>" type="text" id="title" name="title" class="form-control">
            </div>
            <div>
                <label for="link" class="form-label">
                    <?php e__('Link') ?>
                </label>
                <input value="<?php _old('url') ?>" type="text" name="url" id="link" class="form-control">
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" name="insertBroadcast" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>
