<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.appearance.themes.index',
        'text' => t__('Appearance')
    ],
    [
        'text' => t__('CSS')
    ]
];

$this->layout('layouts/main', [
    'title' => t__('CSS'),
    'category' => 'appearance.css',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('styles') ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/codemirror.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/theme/material-ocean.min.css"/>
<style>
    .CodeMirror-gutter .CodeMirror-linenumbers {
        width: 29px !important
    }

    .CodeMirror-gutter-wrapper {
        left: -30px !important
    }

    .CodeMirror-sizer {
        margin-left: 30px !important;
        margin-bottom: -16px !important;
        border-right-width: 14px !important;
        min-height: 160px !important;
        min-width: 78.5px !important;
        padding-right: 0px !important;
        padding-bottom: 0px !important;
    }
</style>
<?php $this->end(); ?>

<?php $this->push('scripts') ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/codemirror.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/mode/css/css.min.js"></script>
<?php $this->end() ?>

<section class="los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('CSS') ?></h1>
    </div>

    <?php _message(); ?>

    <div class="mt-10 card p-6">
        <form action="<?php echo url('dashboard.appearance.css.update') ?>" method="post">
            <?php _method('PATCH') ?>
            <div x-data="codeMirror()">
                <label for="editor" class="form-label pb-2">
                    <?php e__('You can write your custom CSS here.') ?>
                </label>
                <textarea x-ref="editor" id="editor" class="form-control" name="customCSS"><?php _old('customCSS', settings('customCSS')) ?></textarea>
            </div>

            <div class="flex justify-end mt-4">
                <?php _csrf() ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>
