<?php $routes = [
    "custom" => 'Custom Page',
    "home" => 'Homepage',
    "store" => 'Store',
    "games" => 'Games',
    "lottery" => 'Wheel of Fortune',
    "credits" => 'Buy Credits',
    "send-credits" => 'Send Credits',
    "leaderboards" => 'Leaderboards',
    "support" => 'Support',
    "chest" => 'Chest',
    "download" => 'Download',
    "help" => 'Help Center',
    "bazaar" => 'Bazaar',
    "gaming-night" => 'Gaming Night',
    "forum" => 'Forum',
		"staff" => 'Staff',
    "vote" => 'Vote',
    "punishments" => 'Punishments',
    "suggestions" => 'Suggestions',
    "changelog" => 'Changelog',
]; ?>

<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.appearance.themes.index',
        'text' => t__('Appearance')
    ],
    [
        'text' => t__('Header Menu')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Header Menu'),
    'category' => 'appearance.header',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('styles') ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/nestable2/1.6.0/jquery.nestable.min.css">
    <style>
        .cursor-all-scroll {
            cursor: all-scroll !important;
        }
    </style>
<?php $this->end(); ?>

<?php $this->push('scripts') ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/blueimp-md5/2.10.0/js/md5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/nestable2/1.6.0/jquery.nestable.min.js"></script>
<?php $this->end() ?>

<section class="los-container tight-container py-9" x-data="header(<?php echo htmlentities(settings('header'), ENT_QUOTES, 'UTF-8'); ?>)">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Header Menu') ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/appearance/header" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <div @click="showAddElementMenu()" class="cursor-pointer btn btn-primary">
	            <?php e__('Add New Element') ?>
	        </div>
		    </div>
    </div>
	
	<div class="mt-10">
		<div class="lg:col-span-5 flex flex-col gap-10">
			<div class="card">
				<div class="card-title py-4 px-5">
					<?php e__('Menu Elements') ?>
				</div>
				<div class="grid gap-4">
					<div class="dd" id="nestable-header-menu">
						<ol class="dd-list">
							<template x-for="(item, index) in elements" :key="item.id">
								<li class="dd-item headermenu-dd-item" :data-id="item.id" :data-title="item.title"
								    :data-icon="item.icon" :data-url="item.url"
								    :data-tab="item.tab" :data-route="item.route" :data-module="item.module">
									<div class="dd-handle">
										<div class="flex gap-6 pt-3">
											<div class="text-gray-700">
												<i :class="item.icon"></i>
											</div>
											<p class="font-medium text-gray-500" x-text="item.title"></p>
										</div>
									</div>
									<div class="dd-actions">
										<div @click="showEditElementMenu(item)" class="btn btn-sm link-primary">
											<?php e__('Edit') ?>
										</div>
										<div @click="removeElement(index)" class="btn btn-sm link-danger">
											<?php e__('Delete') ?>
										</div>
									</div>
									<template x-if="item.children">
										<ol class='dd-list px-6'>
											<template x-for="(subItem, subIndex) in item.children">
												<li class="dd-item headermenu-dd-item" :data-id="subItem.id" :data-title="subItem.title"
												    :data-icon="subItem.icon" :data-url="subItem.url"
												    :data-tab="subItem.tab" :data-route="subItem.route" :data-module="subItem.module">
													<div class="dd-handle">
														<div class="flex gap-6 pt-3">
															<div class="text-gray-700">
																<i :class="subItem.icon"></i>
															</div>
															<p class="font-medium text-gray-500" x-text="subItem.title"></p>
														</div>
													</div>
													<div class="dd-actions">
														<div @click="showEditElementMenu(subItem)" class="btn btn-sm link-primary">
															<?php e__('Edit') ?>
														</div>
														<div @click="removeElement(index, subIndex)" class="btn btn-sm link-danger">
															<?php e__('Delete') ?>
														</div>
													</div>
												</li>
											</template>
										</ol>
									</template>
								</li>
							</template>
						</ol>
					</div>
				</div>
			</div>
		</div>
	</div>

    <div x-show="showHeaderMenu !== false" class="fixed inset-0" style="z-index: 99;">
      <div @click="hideHeaderMenu()" class="absolute inset-0 bg-black/50 backdrop-blur-[1px]"></div>
      <div class="max-w-xl w-full card p-3 absolute-center -mt-20 duration-200 transition relative"
           x-transition:enter-start="opacity-0 scale-90"
           x-transition:enter-end="opacity-100 scale-100"
           x-transition:leave-start="opacity-100 scale-100"
           x-transition:leave-end="opacity-0 scale-90">
        <div class="py-4 px-6 flex justify-between items-center">
          <div class="text-los font-medium font-maven text-xl"><?php e__('Menu Element') ?></div>
          <div @click="hideHeaderMenu()" class="cursor-pointer text-sm text-gray-400/75 transition hover:text-gray-400">
            <svg class="w-4 fill-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
              <path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"></path>
            </svg>
          </div>
        </div>
        <div x-show="showHeaderMenu === 'add'">
          <div class="py-4 px-6 grid gap-4">
            <div>
              <label for="pageTypeForAdd" class="form-label">
                <?php e__('Page Type') ?>
              </label>
              <select
                x-data="select2Alpine()"
                x-init="
                  $watch('headerMenuModel.route', (value) => selected = value);
                  changed('pageTypeForAdd', () => handleChangeRoute(selected));
                "
                name="pageTypeForAdd"
                id="pageTypeForAdd"
              >
                <?php foreach ($routes as $key => $item): ?>
                  <option value="<?php echo $key ?>"><?php e__($item) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div x-data="iconPicker()">
              <label for="pageTitleForAdd" class="form-label">
                <?php e__('Title') ?>
              </label>
              <div class="flex gap-3">
                <input x-model="headerMenuModel.title" id="pageTitleForAdd" type="text" class="form-control">
                <input type="hidden" x-model="headerMenuModel.icon" x-init="$watch('selectedIcon', () => headerMenuModel.icon = selectedIcon)">
                <div class="relative min-w-[48px] max-w-[48px]" @click.outside="open = false">
                  <div class="cursor-pointer btn btn-success h-full center" @click="open = !open; page = 1;">
                    <i :class="headerMenuModel.icon + ' text-lg'"></i>
                  </div>
                  <div x-show="open" class="absolute z-50 card p-6 top-full right-0 shadow-xl shadow-gray-800/5 w-96 grid grid-cols-7 gap-3">
                    <div class="col-span-7 justify-between flex items-center">
                      <div class="btn btn-primary btn-sm cursor-pointer select-none" :class="page === 1 ? 'opacity-50':''" @click="prevIcons()">
                        <i class="fas fa-angle-left text-lg"></i>
                      </div>
                      <div class="flex gap-2">
                        <input type="number" x-model="page" class="iconp">
                        <span class="text-gray-400">/</span>
                        <span x-text="totalPage"></span>
                      </div>
                      <div class="btn btn-primary btn-sm cursor-pointer select-none" :class="page === totalPage ? 'opacity-50':''" @click="nextIcons()">
                        <i class="fas fa-angle-right text-lg"></i>
                      </div>
                    </div>
                    <div class="col-span-7">
                      <input type="text" class="form-control" x-model="search">
                    </div>
                    <template x-for="(icon, index) in getPage()">
                      <div @click="selectIcon(icon)"
                           class="w-9 h-9 center cursor-pointer rounded-xl"
                           :class="headerMenuModel.icon === icon ? 'bg-blue-500 text-white':'text-gray-700 bg-gray-100/75 transition hover:bg-gray-200/75 hover:border hover:border-gray-200'">
                        <i :class="icon"></i>
                      </div>
                    </template>
                  </div>
                </div>
              </div>
            </div>
            <div>
              <label for="pageLinkForAdd" class="form-label">
                <?php e__('Link') ?>
              </label>
              <input x-model="headerMenuModel.url" type="text" class="form-control" id="pageLinkForAdd" name="pageLinkForAdd">
            </div>
            <div>
	            <?php $this->insert('components/toggle', [
		            'name' => 'pageTabStatusForAdd',
		            'default' => 'headerMenuModel.tab',
		            'labelRight' => t__('Open in new tab'),
		            'init' => "\$watch('headerMenuModel.tab', (value) => this.on = parseInt(value))",
		            'action' => 'headerMenuModel.tab = on;',
	            ]); ?>
            </div>

            <div class="flex justify-end gap-3 items-center">
              <div @click="addElement()" class="btn btn-primary">
                <?php e__('Add') ?>
              </div>
            </div>
          </div>
        </div>
        <div x-show="showHeaderMenu === 'edit'">
          <div class="py-4 px-6 grid gap-4">
            <div>
              <label for="pageTypeForEdit" class="form-label">
                <?php e__('Page Type') ?>
              </label>
              <select
                x-data="select2Alpine()"
                x-init="
                  $watch('headerMenuModel.route', (value) => {
								      if (value !== selected) {
								          selected = value;
								          handleChangeRoute(selected);
								      }
								  });
                  changed('pageTypeForEdit', () => headerMenuModel.route = selected)
                "
                name="pageTypeForEdit"
                id="pageTypeForEdit"
              >
                <?php foreach ($routes as $key => $item): ?>
                  <option value="<?php echo $key ?>"><?php e__($item) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div x-data="iconPicker()">
              <label for="pageTitleForEdit" class="form-label">
                <?php e__('Title') ?>
              </label>
              <div class="flex gap-3">
                <input x-model="headerMenuModel.title" type="text" class="form-control" id="pageTitleForEdit" name="pageTitleForEdit">
                <input type="hidden" x-model="headerMenuModel.icon" x-init="$watch('selectedIcon', () => headerMenuModel.icon = selectedIcon)">
                <div class="relative min-w-[48px] max-w-[48px]" @click.outside="open = false;">
                  <div class="cursor-pointer btn btn-success h-full center" @click="open = !open; page = 1;">
                    <i :class="headerMenuModel.icon + ' text-lg'"></i>
                  </div>
                  <div x-show="open" class="absolute z-50 card p-6 top-full right-0 shadow-xl shadow-gray-800/5 w-96 grid grid-cols-7 gap-3">
                    <div class="col-span-7 justify-between flex items-center">
                      <div class="btn btn-primary btn-sm cursor-pointer select-none" :class="page === 1 ? 'opacity-50':''" @click="prevIcons()">
                        <i class="fas fa-angle-left text-lg"></i>
                      </div>
                      <div class="flex gap-2">
                        <input type="number" x-model="page" class="iconp">
                        <span class="text-gray-400">/</span>
                        <span x-text="totalPage"></span>
                      </div>
                      <div class="btn btn-primary btn-sm cursor-pointer select-none" :class="page === totalPage ? 'opacity-50':''" @click="nextIcons()">
                        <i class="fas fa-angle-right text-lg"></i>
                      </div>
                    </div>
                    <div class="col-span-7">
                      <input type="text" class="form-control" x-model="search">
                    </div>
                    <template x-for="(icon, index) in getPage()">
                      <div @click="selectIcon(icon)"
                           class="w-9 h-9 center cursor-pointer rounded-xl"
                           :class="headerMenuModel.icon === icon ? 'bg-blue-500 text-white':'text-gray-700 bg-gray-100/75 transition hover:bg-gray-200/75 hover:border hover:border-gray-200'">
                        <i :class="icon"></i>
                      </div>
                    </template>
                  </div>
                </div>
              </div>
            </div>
            <div>
              <label for="pageLinkForEdit" class="form-label">
                <?php e__('Link') ?>
              </label>
              <input x-model="headerMenuModel.url" type="text" class="form-control" id="pageLinkForEdit" name="pageLinkForEdit">
            </div>
            <div>
	            <?php $this->insert('components/toggle', [
		            'name' => 'pageTabStatusForEdit',
		            'default' => 'headerMenuModel.tab',
		            'labelRight' => t__('Open in new tab'),
		            'init' => "\$watch('headerMenuModel.tab', (value) => this.on = parseInt(value))",
		            'action' => 'headerMenuModel.tab = on;',
	            ]); ?>
            </div>

            <div class="flex justify-end gap-3 items-center">
              <div @click="updateElement(editingElement)" class="btn btn-primary">
                <?php e__('Update') ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
</section>