<?php $this->layout('layouts/main', [
  'title' => "Overview !",
  'category' => 'arda',
]) ?>

<section class="los-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">Themes</h1>
    </div>
    <div class="mt-10">
        <div class="mt-10 grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php foreach ($availableThemes as $theme): ?>
                <div class="card group">
                    <img class="group-hover:object-bottom transition-all duration-1000 rounded-t-2xl object-cover object-top w-full h-80"
                         src="<?php echo $theme['image'] ?>" alt="">
                    <div class="p-6">
                        <div class="flex justify-between items-center">
                            <h4><?php echo $theme['title'] ?></h4>
                            <div>
                                <?php if ($theme['status'] == 'active'): ?>
                                    <a href="#" class="btn btn-default">Go to settings</a>
                                <?php elseif ($theme['status'] == 'not-active'): ?>
                                    <a href="#" class="btn btn-success btn-sheer">Activate</a>
                                <?php else: ?>
                                    <a href="#" class="btn btn-primary btn-sheer">Buy</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="mt-4">
                            <small class="text-gray-400/75 font-medium text-xs">Information</small>
                            <div class="mt-2 bg-gray-50 rounded-xl py-2 px-3 divide-y divide-gray-600/5 text-sm">
                                <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">Status: <span class="badge badge-danger badge-sm">Not-active</span></div>
                                <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">Price: <span class="text-sm font-normal text-gray-500">150 USD</span></div>
                                <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">Demo: <span class="text-sm font-normal text-gray-500">game.voonos.com/gale</span></div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>

        </div>
    </div>
</section>