<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.appearance.themes.index',
        'text' => t__('Appearance')
    ],
    [
        'url' => 'dashboard.appearance.themes.index',
        'text' => t__('Themes')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Add Theme'),
    'category' => 'appearance.themes',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Add Theme') ?>
        </h1>
        <a href="<?php echo url('dashboard.appearance.themes.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <?php _message(); ?>

    <div class="mt-10 card py-4 px-6">
        <form action="<?php echo url('dashboard.appearance.themes.add.add') ?>" method="post" enctype="multipart/form-data">
            <label x-data="fileSelect" for="themeFile" class="file-group">
                <input x-bind="fileInput" id="themeFile" type="file" name="themeFile" class="hidden" accept=".zip">
                <span class="block w-full border border-gray-200 py-2 px-4 rounded-xl cursor-pointer dark:border-gray-600/20 dark:bg-los-deep dark:text-gray-400" x-bind="textTitle('<?php e__('Choose theme .zip file.') ?>')"></span>
            </label>

            <div class="flex justify-end mt-4">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success"><?php e__('Add') ?></button>
            </div>
        </form>
    </div>
</section>
