<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.appearance.themes.index',
        'text' => t__('Appearance')
    ],
    [
        'text' => t__('Themes')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Themes'),
    'category' => 'appearance.themes',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('styles') ?>
  <style>
      .preview {
          align-items: center;
          width: 100%;
          display: flex;
          justify-content: center;
      }
      .preview .boxImg {
          background: #000;
          width: 100%;
          border-top-left-radius: 0.5rem;
          border-top-right-radius: 0.5rem;
          min-height: 500px;
          transition: ease-in 1s;
      }
      .preview .boxImg {
          background-size: cover !important;
      }
      .preview .boxImg:hover {
          background-position: bottom !important;
      }
  </style>
<?php $this->end(); ?>

<section class="los-container">
  <div class="los-page-heading">
    <h1 class="text-gray-950">
      <?php e__('Themes') ?>
    </h1>
    <a href="<?php echo url('dashboard.appearance.themes.add.index') ?>" class="cursor-pointer btn btn-sm btn-primary">
      <?php e__('Add Theme') ?>
    </a>
  </div>
    <div class="mt-10">
      <div
        class="grid grid-col-2 lg:grid-cols-3 gap-4"
        x-cloak
        x-data="{
          themes: [],
          availableThemes: [<?php echo $availableThemesJS; ?>],
          isLoading: true
        }"
        x-init="
          fetch('<?php echo leaderosApiUrl('api2') ?>/themes.php?domain=<?php echo getDomain($_SERVER["SERVER_NAME"]); ?>')
            .then(response => response.json())
            .then(response => { themes = response; isLoading = false; console.log(response); })
        "
      >
        <div class="order-0">
          <div class="card h-full">
            <div class="preview">
              <div class="boxImg" style="background: url(<?php echo themeJson('thumbnail'); ?>);"></div>
            </div>
            <div class="px-6 py-4">
              <div class="flex items-center gap-2">
                <h3 class="text-gray-800">
                  <?php echo themeJson('name'); ?>
                </h3>
                <span class="badge badge-<?php echo isNeedThemeUpdate() ? 'warning' : 'primary'; ?> !py-1 !px-2">v<?php echo themeJson('version'); ?></span>
              </div>
              <div class="flex gap-2 mt-4">
                <a href="<?php echo url('dashboard.appearance.themes.settings.index') ?>" class="btn btn-primary !py-2.5 !text-sm  !font-medium flex items-center justify-center w-full">
                  <?php e__('Settings') ?>
                </a>
                <?php if (isNeedThemeUpdate()): ?>
                  <a href="<?php echo url('dashboard.appearance.themes.update.index') ?>" class="btn btn-success !py-2.5 !text-sm  !font-medium flex items-center justify-center w-1/4" x-bind="tooltip('<?php e__('Update') ?>')">
                    <i class="stroke-white stroke-2 w-5" data-feather="refresh-2"></i>
                  </a>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
        <?php foreach ($availableThemes as $theme): ?>
          <?php $themeSettings = json_decode(file_get_contents(__ROOT__.'/apps/main/app/views/themes/'.$theme."/theme.json"), true) ?>
          <div class="order-1">
            <div class="card h-full">
              <div class="preview">
                <div class="boxImg" style="background: url(<?php echo $themeSettings["thumbnail"]; ?>);"></div>
              </div>
              <div class="px-6 py-4">
                <h3 class="text-gray-800">
                  <?php echo $themeSettings["name"]; ?>
                </h3>
                <div class="mt-4">
                  <form action="<?php echo url('dashboard.appearance.themes.set') ?>?theme=<?php echo $themeSettings["id"]; ?>" method="post">
                    <?php _csrf(); ?>
                    <button type="submit" class="btn btn-primary !py-2.5 !text-sm  !font-medium flex items-center justify-center w-full">
                      <?php e__('Activate') ?>
                    </button>
                  </form>
                </div>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
        <?php for ($i = 0; $i < (4 - (count($availableThemes)+1) % 4); $i++): ?>
          <div class="order-2" x-show="isLoading">
            <div class="card h-full">
              <div class="sl sl-image sl-animation-shimmer"></div>
              <div class="px-6 py-4">
                <div class="sl sl-title sl-rounded-md sl-animation-shimmer"></div>
                <div class="grid grid-cols-2 gap-2 mt-4">
                  <div>
                    <div class="sl sl-button w-full sl-animation-shimmer mt-4"></div>
                  </div>
                  <div>
                    <div class="sl sl-button w-full sl-animation-shimmer mt-4"></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php endfor; ?>
        <template x-for="theme in themes" :key="theme.id">
          <div :class="(theme.isPurchased ? 'order-1' : 'order-2')" x-show="(theme.slug == '<?php echo themeName() ?>' || availableThemes.includes(theme.slug)) ? false : true">
            <div class="card h-full">
              <div class="preview">
                <div class="boxImg" :style="{background: 'url(' + theme.thumbnail + ')'}"></div>
              </div>
              <div class="px-6 py-4">
                <div class="flex justify-between items-center mb-4">
                  <h3 x-text="theme.name" class="text-gray-800"></h3>
                  <div x-show="!theme.isPurchased" class="text-lg font-medium">
                    <span x-text="theme.price == 0 ? '<?php e__('Free') ?>' : (theme.currencySymbol + theme.price)" class="text-gray-800"></span>
                  </div>
                </div>
                <div x-show="!theme.isPurchased" class="grid grid-cols-1 lg:grid-cols-2 gap-2">
                  <div>
                    <a x-bind:href="theme.demo + '&game=<?php echo settings('gameType') ?>'" target="_blank" class="btn btn-default w-full flex items-center justify-center !py-2.5 !text-sm  !font-medium">Demo</a>
                  </div>
                  <div>
                    <a x-bind:href="theme.buyLink" target="_blank" class="btn btn-success w-full flex items-center justify-center !py-2.5 !text-sm  !font-medium"><?php e__('Buy') ?></a>
                  </div>
                </div>
                <div x-data="{ isDisabled: false }">
                  <button
                    type="button"
                    x-show="theme.isPurchased"
                    x-on:click="isDisabled = true; $request('<?php echo url('dashboard.appearance.themes.install') ?>?theme=' + theme.slug).then(res => { location.reload(); }).catch((err) => { console.log(err) })"
                    x-bind:disabled="isDisabled"
                    class="btn btn-success w-full flex justify-center items-center !py-2.5 !text-sm  !font-medium"
                    :class="isDisabled && 'cursor-not-allowed opacity-50'"
                  >
                    <span x-show="!isDisabled"><?php e__('Install') ?></span>
                    <span x-show="isDisabled">
                        <svg class="animate-spin -ml-1 mr-3 h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                          <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                          <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                      </span>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </template>
      </div>
    </div>
</section>