<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.appearance.themes.index',
        'text' => t__('Appearance')
    ],
    [
        'url' => 'dashboard.appearance.themes.index',
        'text' => t__('Themes')
    ],
    [
        'text' => t__('Settings')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Theme Settings'),
    'category' => 'appearance.themes.settings',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('styles') ?>
<style>
	div[data-requirements] {
		display: none;
	}
</style>
<?php $this->end() ?>

<?php $this->push('scripts') ?>
<script>
	function updateSettingsVisibility() {
		// Select all elements with the `data-requirements` attribute
		document.querySelectorAll('[data-requirements]').forEach(container => {
			// Get the `data-requirements` content and split it into a list of dependencies
			const requiredKeys = container.getAttribute('data-requirements').split(',');
			
			// Check if all requirements are met
			const isRequirementsMet = requiredKeys.every(reqKey => {
				const requiredElement = document.querySelector(`[name="settings_${reqKey.trim()}"]`);
				return requiredElement.value === "1"; // Check if the checkbox is checked
			});
			
			// Show the container if all requirements are met, otherwise hide it
			container.style.display = isRequirementsMet ? 'block' : 'none';
		});
	}
	
	$(document).ready(function() {
		updateSettingsVisibility();
	});

</script>
<?php $this->end() ?>

<section class="los-container tight-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Theme Settings') ?>
        </h1>
        <a href="<?php echo url('dashboard.appearance.themes.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <?php _message(); ?>
	
	<div class="mt-10 card">
		<div class="tab-container !flex-row !pt-4 px-4 gap-2">
			<?php foreach ($themeJson["settingsCategories"] as $key => $themeSettingsCategories): ?>
				<a class="tab-item <?php echo get("category") == $key ? "active" : null ?>" href="?category=<?php echo $key ?>">
					<?php echo $themeSettingsCategories["name"]; ?>
				</a>
			<?php endforeach; ?>
		</div>
		<form action="<?php echo url('dashboard.appearance.themes.settings.update') ?>" method="post" enctype="multipart/form-data" class="flex flex-col gap-4 px-6 pb-6">
			<?php _method('PATCH') ?>
			<?php foreach ($themeJson["settingsCategories"][get("category")]["settings"] as $key => $themeSettings): ?>
				<?php $settingsValue = settings("theme:$themeName:" . $key); ?>
				<div <?php echo isset($themeSettings["requirements"]) ? 'data-requirements="'.implode(',', $themeSettings["requirements"]).'"' : '' ?>>
					<label for="input-<?php echo $key; ?>" class="form-label"><?php echo $themeSettings["settings"]["title"] ?>:</label>
					<div class="col-sm-9">
						<?php if ($themeSettings["settings"]["type"] == "select"): ?>
							<select x-data="select2Alpine()" id="input-<?php echo $key; ?>" class="form-control" name="settings_<?php echo $key; ?>">
								<?php foreach ($themeSettings["settings"]["values"] as $value): ?>
									<option value="<?php echo $value["value"]; ?>" <?php echo ($settingsValue == $value["value"]) ? 'selected="selected"' : null; ?>><?php echo $value["text"] ?></option>
								<?php endforeach; ?>
							</select>
						<?php endif; ?>
						
						<?php if ($themeSettings["settings"]["type"] == "input"): ?>
							<input type="text" id="input-<?php echo $key; ?>" class="form-control" name="settings_<?php echo $key; ?>" value="<?php echo $settingsValue; ?>">
						<?php endif; ?>
						
						<?php if ($themeSettings["settings"]["type"] == "checkbox"): ?>
							<?php $this->insert('components/toggle', [
								'id' => 'input-' . $key,
								'name' => 'settings_' . $key,
								'default' => $settingsValue == "1" ? "1" : "0",
								'action' => '$nextTick(() => { updateSettingsVisibility() });'
							]); ?>
						<?php endif; ?>
						
						<?php if ($themeSettings["settings"]["type"] == "image"): ?>
							<div x-data="image">
								<div class="mt-2 image-group" x-bind="imageContainer">
									<img x-show="imagePreview === null" src="<?php echo $settingsValue . "?cache=" . settings("updatedAt"); ?>" alt="">
									<img x-show="imagePreview !== null" :src="imagePreview" alt="">
									<span>
										<?php e__('Select an image') ?>
									</span>
									<input name="settings_<?php echo $key; ?>" id="file-<?php echo $key; ?>" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
								</div>
							</div>
						<?php endif; ?>
						
						<?php if ($themeSettings["settings"]["type"] == "color"): ?>
							<div class="coloris-container square">
								<input type="text" id="input-<?php echo $key; ?>" class="form-control coloris" x-data="colorPicker()" name="settings_<?php echo $key; ?>" value="<?php echo $settingsValue; ?>">
							</div>
						<?php endif; ?>
					</div>
				</div>
			<?php endforeach; ?>
			
			<input type="hidden" name="category" value="<?php echo get("category"); ?>">
			
			<div class="flex justify-end">
				<?php _csrf(); ?>
				<button type="submit" class="btn btn-success">
					<?php e__('Save Changes') ?>
				</button>
			</div>
		</form>
	</div>
</section>