<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.appearance.themes.index',
        'text' => t__('Appearance')
    ],
    [
        'url' => 'dashboard.appearance.themes.index',
        'text' => t__('Themes')
    ],
    [
        'text' => t__('Update')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Update Theme'),
    'category' => 'appearance.themes',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section
  x-data="{
    isNeedUpdate: <?php echo isNeedThemeUpdate() ? 'true' : 'false' ?>,
    inProcess: false,
    isUpdated: null,
    updateTheme() {
      this.inProcess = true;
      return $request('<?php echo url('dashboard.appearance.themes.update.update') ?>')
        .then(response => response.data)
        .then(result => {
          this.inProcess = false;
          this.isUpdated = result.status;
        });
    }
  }"
  class="los-container tight-container py-9"
>
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Update Theme') ?>
        </h1>
        <a href="<?php echo url('dashboard.appearance.themes.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <div class="mt-10">
      <div class="card">
        <div x-show="isNeedUpdate">
          <div x-show="isUpdated === null">
            <div x-show="!inProcess" class="flex flex-col items-center justify-center py-10">
              <i data-feather="refresh-2" class="text-gray-800 stroke-2 w-12 h-12 mb-4"></i>
              <h3 class="text-gray-950 mb-1">
                <?php e__('Updates available!') ?>
              </h3>
              <p class="text-gray-600">
                <?php e__('A new Theme update is out! Click Update button to use the latest version.') ?>
              </p>
              <div class="mt-5">
                <button @click="updateTheme()" type="button" class="btn btn-success">
                  <?php e__('Update') ?>
                </button>
              </div>
            </div>

            <div x-show="inProcess" class="flex flex-col items-center justify-center py-10">
              <svg class="animate-spin h-12 w-12 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
              </svg>
              <h4 class="text-gray-950 mt-5">
                <?php e__('Updating...') ?>
              </h4>
            </div>
          </div>

          <div x-show="isUpdated !== null" class="flex flex-col items-center justify-center py-10">
            <div x-show="isUpdated === false">
              <i data-feather="x" class="text-red-500 stroke-2 w-12 h-12 mb-4"></i>
            </div>
            <div x-show="isUpdated === true">
              <i data-feather="tick-circle" class="text-emerald-500 stroke-2 w-12 h-12 mb-4"></i>
            </div>
            <h4 class="text-gray-950">
              <span x-show="isUpdated === false">
                <?php e__('Update failed! Please try again later or contact us.') ?>
              </span>
              <span x-show="isUpdated === true">
                <?php e__('Update completed successfully!') ?>
              </span>
            </h4>
          </div>
        </div>

        <div x-show="!isNeedUpdate" class="flex flex-col items-center justify-center py-10">
          <i data-feather="tick-circle" class="text-emerald-500 stroke-2 w-12 h-12 mb-4"></i>
          <h3 class="text-gray-950 mb-1">
            <?php e__("You're up to date!") ?>
          </h3>
          <p class="text-gray-600">
            <?php e__('You are using the latest version!') ?>
          </p>
        </div>
      </div>
    </div>
</section>
