<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.applications.index',
        'text' => t__('Applications')
    ],
    [
        'url' => 'dashboard.applications.forms.index',
        'text' => t__('Forms')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $form['title']]),
    'category' => 'forms.applications.forms',
    'breadcrumbs' => $breadcrumbs
]);
?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $form['title']]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/staff-applications" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.applications.forms.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.applications.forms.update', ['id' => $form['id']]) ?>" method="post" class="grid gap-4 mt-10">
        <div class="card p-6 grid gap-4">
            <?php _method('PATCH') ?>
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('title', $form['title']) ?>" type="text" id="title" name="title" class="form-control">
            </div>
            <div x-data="textEditor()">
                <label for="content" class="form-label">
                    <?php e__('Description') ?>
                </label>
                <div x-data="textEditor()" class="mt-2">
                    <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="description" id="content"
                    ><?php _old('description', $form['description']) ?></textarea>
                </div>
            </div>

            <div>
              <?php $this->insert('components/toggle', [
                'name' => 'reappliable',
                'default' => old('reappliable', $form["reappliable"]),
                'labelTop' => t__('Re-Appliable')
              ]); ?>
            </div>
        </div>
	      <div class="card p-6 grid gap-4">
		      <?php
			      $defaultInputs = array_map(function($formQuestion, $formQuestionType, $formQuestionVariables) {
				      return [
					      'formQuestion' => $formQuestion,
					      'formQuestionType' => $formQuestionType,
					      'formQuestionVariables' => $formQuestionVariables
				      ];
			      }, old('formQuestion', array_column($questions, 'question')), old('formQuestionType', array_column($questions, 'type')), old('formQuestionVariables', array_column($questions, 'variables')));
		      ?>
		      <div x-data="inputArray({
                      formQuestion: '',
                      formQuestionType: '',
                      formQuestionVariables: ''
                    }, <?php echo htmlentities(json_encode($defaultInputs)) ?>)"
		      >
			      <div class="flex justify-between items-center">
				      <div class="card-title">
					      <?php e__('Questions') ?>
				      </div>
				      <span @click="addInput()" class="btn btn-sm btn-sheer btn-primary cursor-pointer flex items-center justify-center gap-1">
					      <i data-feather="add" class="w-4 h-4 -ml-1"></i>
					      <?php e__('Add') ?>
				      </span>
			      </div>
			      <table class="mt-3 table">
				      <colgroup>
					      <col style="width: 40%;">
					      <col style="width: 20%;">
					      <col style="width: 40%;">
				      </colgroup>
				      <thead class="">
				      <tr class="table-header !text-xs !text-gray-500">
					      <th scope="col" class="!text-left">
						      <?php e__('Question') ?>
					      </th>
					      <th scope="col" class="!text-left">
						      <?php e__('Type') ?>
					      </th>
					      <th scope="col" class="!text-left">
						      <?php e__('Variables') ?>
					      </th>
					      <th scope="col" style="width: 40px">
						      <span class="sr-only">
							      <?php e__('Actions') ?>
						      </span>
					      </th>
				      </tr>
				      </thead>
				      <tbody class="divide-y divide-gray-200/20 text-center">
				      <template x-for="(input, index) in inputs" :key="index">
					      <tr>
						      <td class="!text-left !pl-0">
							      <input type="text" class="form-control" name="formQuestion[]" x-bind:value="input.formQuestion">
						      </td>
						      <td class="!text-left !pl-0">
							      <select name="formQuestionType[]" class="form-control" x-model="input.formQuestionType">
								      <option value="1" :selected="input.formQuestionType === '1'"><?php e__("Short Text")?></option>
								      <option value="2" :selected="input.formQuestionType === '2'"><?php e__("Long Text")?></option>
								      <option value="3" :selected="input.formQuestionType === '3'"><?php e__("Single-Select")?></option>
								      <option value="4" :selected="input.formQuestionType === '4'"><?php e__("Multi-Select")?></option>
							      </select>
						      </td>
						      <td class="!text-left !pl-0">
							      <span x-show="input.formQuestionType !== '3' && input.formQuestionType !== '4'">-</span>
							      <input x-show="input.formQuestionType === '3' || input.formQuestionType === '4'" type="text" class="form-control" name="formQuestionVariables[]" x-bind:value="input.formQuestionVariables">
						      </td>
						      <td class="justify-end flex items-center !px-0" style="width: 40px;">
							      <div @click="deleteInput(index)" class="btn btn-sheer btn-danger">
								      <i class="stroke-red-500 stroke-2 w-4" data-feather="trash"></i>
							      </div>
						      </td>
					      </tr>
				      </template>
				      </tbody>
			      </table>
		      </div>
	      </div>
        <div class="flex justify-end">
            <?php _csrf(); ?>
            <button type="submit" class="btn btn-success">
                <?php e__('Save Changes') ?>
            </button>
        </div>
    </form>
</section>