<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.applications.index',
        'text' => t__('Applications')
    ],
    [
        'text' => t__('Forms')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Application Forms'),
    'category' => 'forms.applications.forms',
    'breadcrumbs' => $breadcrumbs
]) ?>


<section class="los-container py-9">
    <?php if (count($forms) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Application Forms') ?>
            </h1>
            <a href="<?php echo url('dashboard.applications.forms.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Application Forms')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="title">
								    <?php e__('Title') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="date">
								    <?php e__('Date') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($forms as $form): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.applications.forms.edit', ['id' => $form['id']]) ?>" class="title"><?php echo $form['title'] ?></a>
								    <div>#<?php echo $form['id'] ?></div>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($form["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($form["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="/applications/forms/<?php echo $form['slug'] ?>" target="_blank" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <a href="<?php echo url('dashboard.applications.forms.edit', ['id' => $form['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.applications.forms.destroy', ['id' => $form['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No application forms found!'),
            'details' => t__('You can create a new application form by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.applications.forms.create',
                'text' => t__('Create Application Form')
            ],
        ]);
    endif; ?>
</section>
