<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.applications.index',
        'text' => t__('Applications')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Applications'),
    'category' => 'forms.applications',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($applications) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Applications') ?>
            </h1>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 !grid grid-cols-12">
				    <div class="col-span-9">
					    <form method="get" action="<?php echo url('dashboard.applications.index') ?>" class="w-full">
						    <label for="search" class="form-label">
							    <?php e__('Search for %text%', ['%text%' => t__('Applications')]) ?>
						    </label>
						    <div class="input-absolute-group">
							    <i data-feather="search-normal"></i>
							    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
						    </div>
					    </form>
				    </div>
				    <div class="col-span-3">
					    <div class="flex w-full h-full">
						    <div x-data="dropdown()" class="relative w-full">
							    <label class="form-label">
								    <?php e__('Status') ?>
							    </label>
							    <div @click="toggle()" class="btn btn-sm btn-input">
								    <span x-text="selected"></span>
								    <i data-feather="arrow-down" class="w-4 h-4"></i>
							    </div>
							    
							    <div x-bind="isDropdown" class="dropdown w-full">
								    <a href="<?php echo url('dashboard.applications.index') ?>">
									    <?php e__('Show All') ?>
								    </a>
								    <a href="<?php echo url('dashboard.applications.index') ?>?status=0" class="<?php _active(get('status') === '0'); ?>">
									    <?php e__('Rejected') ?>
								    </a>
								    <a href="<?php echo url('dashboard.applications.index') ?>?status=1" class="<?php _active(get('status') === '1'); ?>">
									    <?php e__('Approved') ?>
								    </a>
								    <a href="<?php echo url('dashboard.applications.index') ?>?status=2" class="<?php _active(get('status') === '2'); ?>">
									    <?php e__('Pending Approval') ?>
								    </a>
							    </div>
						    </div>
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <?php e__('Title') ?>/<?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('Status') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($applications as $application): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.applications.show', ['id' => $application["id"]]); ?>"><?php echo $application['title'] ?></a>
								    <div>#<?php echo $application['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $application['accountID']]) ?>"><?php echo $application['realname'] ?></a>
								    <div>@<?php echo $application['username'] ?></div>
							    </td>
							    <td class="not">
								    <?php
									    if ($application['status'] == 0): ?>
										    <span class="badge badge-danger"><?php e__('Rejected') ?></span>
									    <?php elseif ($application["status"] == 1): ?>
										    <span class="badge badge-success"><?php e__('Approved') ?></span>
									    <?php elseif ($application["status"] == 2): ?>
										    <span class="badge badge-warning"><?php e__('Pending Approval') ?></span>
									    <?php else: ?>
										    ERROR!
									    <?php endif; ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($application["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($application["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.applications.show', ['id' => $application["id"]]); ?>" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <form action="<?php echo url('dashboard.applications.destroy', ['id' => $application["id"]]); ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No applications found!'),
            'details' => t__('There are no applications to show here.')
        ]);
    endif; ?>
</section>
