<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.applications.index',
        'text' => t__('Applications')
    ],
    [
        'text' => t__('View')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('View Application'),
    'category' => 'forms.applications',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('View Application') ?>
        </h1>
        <a href="<?php echo url('dashboard.applications.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <?php _message(); ?>

    <div class="grid gap-4 mt-10">
        <div class="card">
            <div class="card-title py-4 px-6">
                <?php e__('Details') ?>
            </div>
            <div class="py-4 px-6 grid xl:grid-cols-4 gap-4 text-gray-500 text-sm">
                <div>
                    <div class="font-medium text-gray-600">
                        <?php e__('User') ?>:
                    </div>
                    <a href="<?php echo url('dashboard.accounts.show', ['id' => $application['accountID']]) ?>">
                      <?php echo $application["realname"]; ?>
                    </a>
		                <div class="text-xs">
			                @<?php echo $application["username"]; ?>
		                </div>
                </div>
                <div>
                    <div class="font-medium text-gray-600">
                        <?php e__("Form") ?>:
                    </div>
                    <?php echo $application['title'] ?>
                </div>
                <div class="">
                    <div class="font-medium text-gray-600">
                        <?php e__("Status") ?>:
                    </div>
                    <div class="mt-1">
                        <?php if ($application["status"] == 0): ?>
                            <span class="badge badge-danger"><?php e__('Rejected') ?></span>
                        <?php elseif ($application["status"] == 1): ?>
                            <span class="badge badge-success"><?php e__('Approved') ?></span>
                        <?php elseif ($application["status"] == 2): ?>
                            <span class="badge badge-warning"><?php e__('Pending Approval') ?></span>
                        <?php else: ?>
                            <?php e__('Error!') ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div>
                    <div class="font-medium text-gray-600" w>
                        <?php e__("Date") ?>
                    </div>
                    <?php echo convertTime($application["creationDate"], 2, true); ?>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-title pt-4 px-6"><?php e__('Questions') ?></div>
            <div class="py-4 px-6">
                <?php foreach ($answers as $answer): ?>
                    <div class="rounded-xl bg-gray-100 py-3 px-6 mb-3">
                        <div class="text-gray-700 font-semibold capitalize">
                            <?php echo $answer["question"] ?>
                        </div>
                        <div class="text-gray-500 text-sm mt-3">
                            <?php echo $answer["answer"]; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
	    
		    <div class="card">
			    <div class="card-title pt-4 px-6"><?php e__('Reason') ?>:</div>
			    <div class="py-4 px-6">
				    <textarea class="form-control" id="reasonField" rows="3"><?php echo $application["reason"]; ?></textarea>
				    
				    <div class="mt-4 flex justify-end items-center gap-2">
					    <form id="rejectForm" action="<?php echo url('dashboard.applications.reject', ['id' => $application['id']]) ?>" method="post" data-submit-loading>
						    <?php _csrf(); ?>
						    <button type="submit" class="btn btn-danger" name="rejectApplication" onclick="submitForm('rejectForm')">
							    <?php e__('Reject') ?>
						    </button>
						    <input type="hidden" name="reason" id="rejectReason">
					    </form>
					    <form id="approveForm" action="<?php echo url('dashboard.applications.approve', ['id' => $application['id']]) ?>" method="post" data-submit-loading>
						    <?php _csrf(); ?>
						    <button type="submit" class="btn btn-success" name="approveApplication" onclick="submitForm('approveForm')">
							    <?php e__("Approve") ?>
						    </button>
						    <input type="hidden" name="reason" id="approveReason">
					    </form>
				    </div>
			    </div>
		    </div>
    </div>
</section>

<?php $this->push('scripts') ?>
	<script>
		function submitForm(formId){
			var reason = document.getElementById('reasonField').value;
			document.getElementById(formId).querySelector('input[name="reason"]').value = reason;
			document.getElementById(formId).submit();
		}
	</script>
<?php $this->end() ?>