<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.bans.index',
        'text' => t__('Bans')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__("Editing %user%'s ban", ['%user%' => $ban['realname']]),
    'category' => 'user-management.actions.ban-user',
    'breadcrumbs' => $breadcrumbs
]); ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__("Editing %user%'s ban", ['%user%' => $ban['realname']]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/ban-management" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.bans.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.bans.update', ['id' => $ban['id']]) ?>" method="post" class="grid gap-4">
            <?php _method('PATCH') ?>
            <div>
	            <label for="userID" class="form-label">
		            <?php echo t__('Search User') ?>
	            </label>
	            <?php $this->insert('components/search-user', [
		            'userID' => $ban["accountID"],
		            'disabled' => true
	            ]); ?>
            </div>
            <div>
                <label for="categoryID" class="form-label">
                    <?php e__('Category') ?>
                </label>
                <select x-data="select2Alpine()" name="categoryID" id="categoryID">
                    <option value="1" <?php _selected(old('categoryID', $ban["categoryID"]) == 1); ?>>
                        <?php e__('Website') ?>
                    </option>
                    <option value="2" <?php _selected(old('categoryID', $ban["categoryID"]) == 2); ?>>
                        <?php e__('Support') ?>
                    </option>
                    <option value="3" <?php _selected(old('categoryID', $ban["categoryID"]) == 3); ?>>
                        <?php e__('Comments') ?>
                    </option>
                </select>
            </div>

            <div>
                <label for="reasonID" class="form-label">
                    <?php e__('Reason') ?>
                </label>
                <select x-data="select2Alpine()" name="reasonID" id="reasonID">
                    <option value="2" <?php _selected(old('reasonID', $ban["reasonID"]) == 2); ?>>
                        <?php e__('Spam') ?>
                    </option>
                    <option value="3" <?php _selected(old('reasonID', $ban["reasonID"]) == 3); ?>>
                        <?php e__('Swear/Insulting') ?>
                    </option>
                    <option value="4" <?php _selected(old('reasonID', $ban["reasonID"]) == 4); ?>>
                        <?php e__('Cheat') ?>
                    </option>
                    <option value="5" <?php _selected(old('reasonID', $ban["reasonID"]) == 5); ?>>
                        <?php e__('Advertising') ?>
                    </option>
                    <option value="6" <?php _selected(old('reasonID', $ban["reasonID"]) == 6); ?>>
                        <?php e__('Scamming Players') ?>
                    </option>
                    <option value="1" <?php _selected(old('reasonID', $ban["reasonID"]) == 1); ?>>
                        <?php e__('Other') ?>
                    </option>
                </select>
            </div>
            <div x-data="{durationStatus: '<?php _old('durationStatus', ($ban["expiryDate"] == '1000-01-01 00:00:00' ? '0' : '1')) ?>'}">
                <div>
                    <label for="durationStatus" class="form-label">
                        <?php e__('Duration Status') ?>
                    </label>
                    <select x-data="select2Alpine()" x-init="changed('durationStatus',() => durationStatus=selected)" name="durationStatus" id="durationStatus">
                        <option value="0" <?php _selected(old('durationStatus', ($ban["expiryDate"] == '1000-01-01 00:00:00' ? '0' : '1')) == 0); ?>>
                            <?php e__('Permanent') ?>
                        </option>
                        <option value="1" <?php _selected(old('durationStatus', ($ban["expiryDate"] == '1000-01-01 00:00:00' ? '0' : '1')) == 1); ?>>
                            <?php e__('Temporary') ?>
                        </option>
                    </select>
                </div>

                <div x-show="durationStatus === '1'" class="mt-3">
                    <label for="duration" class="form-label">
                      <?php e__('Duration') ?> (<?php e__('Days') ?>)
                    </label>
                    <input value="<?php _old('duration', ($ban["expiryDate"] != '1000-01-01 00:00:00') ? getDuration($ban["expiryDate"]) : null) ?>" type="text" id="duration" name="duration" class="form-control">
                </div>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>

