<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.bans.index',
        'text' => t__('Bans')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Bans'),
    'category' => 'user-management.bans',
    'breadcrumbs' => $breadcrumbs
]) ?>


<section class="los-container py-9">
    <?php if (count($bans) > 0 || get("search") || get("status")): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Bans') ?>
            </h1>
            <a href="<?php echo url('dashboard.bans.create') ?>" class="btn btn-primary">
                <?php e__('Ban User') ?>
            </a>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 !grid grid-cols-12">
				    <div class="col-span-9">
					    <form method="get" action="<?php echo url('dashboard.bans.index') ?>" class="w-full">
						    <label for="search" class="form-label">
							    <?php e__('Search for %text%', ['%text%' => t__('Bans')]) ?>
						    </label>
						    <div class="input-absolute-group">
							    <i data-feather="search-normal"></i>
							    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
						    </div>
					    </form>
				    </div>
				    <div class="col-span-3">
					    <div class="flex w-full h-full">
						    <div x-data="dropdown()" class="relative w-full">
							    <label class="form-label">
								    <?php e__('Category') ?>
							    </label>
							    <div @click="toggle()" class="btn btn-sm btn-input">
								    <span x-text="selected"></span>
								    <i data-feather="arrow-down" class="w-4 h-4"></i>
							    </div>
							    
							    <div x-bind="isDropdown" class="dropdown w-full">
								    <a href="<?php echo url('dashboard.bans.index') ?>">
									    <?php e__('Show All') ?>
								    </a>
								    <a href="<?php echo url('dashboard.bans.index') ?>?status=1" class="<?php _active(get('status') == '1'); ?>">
									    <?php e__('Website') ?>
								    </a>
								    <a href="<?php echo url('dashboard.bans.index') ?>?status=2" class="<?php _active(get('status') == '2'); ?>">
									    <?php e__('Support') ?>
								    </a>
								    <a href="<?php echo url('dashboard.bans.index') ?>?status=3" class="<?php _active(get('status') == '3'); ?>">
									    <?php e__('Comments') ?>
								    </a>
							    </div>
						    </div>
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('Category') ?>
						    </th>
						    <th>
							    <?php e__('Reason') ?>
						    </th>
						    <th class="date">
							    <?php e__('Expiry') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($bans as $ban): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $ban['accountID']]) ?>" class="text-sm font-medium text-gray-800"><?php echo $ban['realname'] ?></a>
								    <div>@<?php echo $ban['username'] ?></div>
							    </td>
							    <td>
								    <?php if ($ban["categoryID"] == 1): ?>
									    <?php e__("Site") ?>
								    <?php elseif ($ban["categoryID"] == 2): ?>
									    <?php e__("Support") ?>
								    <?php elseif ($ban["categoryID"] == 3): ?>
									    <?php e__("Comment") ?>
								    <?php else: ?>
									    <?php e__("Error!") ?>
								    <?php endif; ?>
							    </td>
							    <td>
								    <?php if ($ban["reasonID"] == 1):
									    e__("Other");
								    else:
									    if ($ban["reasonID"] == 2):
										    e__("Spam");
									    elseif ($ban["reasonID"] == 3):
										    
										    e__("Swear/Insulting") ?>
									    <?php elseif ($ban["reasonID"] == 4): ?>
										    <?php e__("Cheating") ?>
									    <?php elseif ($ban["reasonID"] == 5): ?>
										    <?php e__("Advertising") ?>
									    <?php elseif ($ban["reasonID"] == 6): ?>
										    <?php e__("Scamming Players") ?>
									    <?php else: ?>
										    <?php e__("Error!") ?>
									    <?php endif; ?>
								    <?php endif; ?>
							    </td>
							    <td class="date">
								    <?php if ($ban["expiryDate"] == '1000-01-01 00:00:00'): ?>
									    <?php e__('Permanent') ?>
								    <?php else: ?>
									    <div><?php echo convertTime($ban["expiryDate"], 2, true) ?></div>
									    <div><?php e__('%days% day(s)', ['%days%' => getDuration($ban["expiryDate"])]) ?></div>
								    <?php endif; ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($ban["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($ban["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.bans.edit', ['id' => $ban['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.bans.destroy', ['id' => $ban['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Unban') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No bans found!'),
            'details' => t__('You can ban a user by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.bans.create',
                'text' => t__('Ban User')
            ],
        ]);
    endif; ?>

</section>
