<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.bazaar.index',
        'text' => t__('Bazaar')
    ],
    [
        'url' => 'dashboard.bazaar.custom-item-images.index',
        'text' => t__('Custom Item Images')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Custom Item Image'),
    'category' => 'misc.bazaar.custom-item-images',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Custom Item Image') ?></h1>
        <a href="<?php echo url('dashboard.bazaar.custom-item-images.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form class="grid gap-4" action="<?php echo url('dashboard.bazaar.custom-item-images.create') ?>" method="post" enctype="multipart/form-data">
            <div>
                <label for="itemID" class="form-label">
                    <?php e__('Item') ?>
                </label>
                <select x-data="minecraftIconPicker('air', true)" name="itemID" id="itemID">
                    <option></option>
                </select>
            </div>
            <div>
                <label for="modelID" class="form-label">
                    <?php e__('Model ID') ?>
                </label>
                <input value="<?php _old('modelID') ?>" type="text" name="modelID" id="modelID" class="form-control">
            </div>
            <div>
                <label for="serverID" class="form-label">
                    <?php e__('Server') ?>
                </label>
                <select x-data="select2Alpine()" name="serverID" id="serverID">
                    <?php foreach ($servers as $server): ?>
                        <option value="<?php echo $server["id"] ?>"><?php echo $server["name"] ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div x-data="image">
                <label for="picture" class="form-label">
                    <?php e__('Image') ?>
                </label>
                <div class="mt-2 image-group" x-bind="imageContainer">
                    <img x-show="imagePreview !== null" :src="imagePreview" alt="">
                    <span>
                      <?php e__('Select an image') ?>
                    </span>
                    <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                </div>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>