<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.bazaar.index',
        'text' => t__('Bazaar')
    ],
    [
        'text' => t__('Custom Item Images')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Custom Item Images'),
    'category' => 'misc.bazaar.custom-item-images',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($itemImages) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Custom Item Images') ?>
            </h1>
            <a href="<?php echo url('dashboard.bazaar.custom-item-images.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Custom Item Images')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="itemID">
								    <?php e__('Item ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="modelID">
								    <?php e__('Model ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="server">
								    <?php e__('Server') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($itemImages as $itemImage): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.bazaar.custom-item-images.edit', ['id' => $itemImage['id']]) ?>" class="itemID">
									    <?php echo $itemImage['itemID'] ?>
								    </a>
							    </td>
							    <td class="modelID">
								    <?php echo $itemImage['modelID'] ?>
							    </td>
							    <td class="server">
								    <?php echo $itemImage['serverName'] ?>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.bazaar.custom-item-images.edit', ['id' => $itemImage['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.bazaar.custom-item-images.destroy', ['id' => $itemImage['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No custom item images found!'),
            'details' => t__('You can create a new custom item image by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.bazaar.custom-item-images.create',
                'text' => t__('Create Custom Item Image'),
            ],
        ]);
    endif; ?>
</section>
