<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.bazaar.index',
        'text' => t__('Bazaar')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $bazaarItem['name']]),
    'category' => 'misc.bazaar.items',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $bazaarItem['name']]) ?>
        </h1>
        <a href="<?php echo url('dashboard.bazaar.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <?php _message(); ?>

    <div class="grid grid-cols-3 gap-4">
        <div class="col-span-1">
            <div class="card p-6 mt-10 flex flex-col gap-3">
                <div class="flex justify-center">
                    <div class="pb-6">
                        <?php
                        $image = '/assets/core/images/items/' . strtolower($bazaarItem["itemID"]) . '.png';
                        if ($bazaarItem["modelID"] != null) {
                            $image = '/assets/core/images/items/custom/' . $bazaarItem["imageID"] . '.' . $bazaarItem["imageType"];
                        }
                        ?>
                        <img width="64px" src="<?php echo $image; ?>"/>
                    </div>
                </div>
                <div>
                    <strong class="text-gray-950"><?php e__("Item Name") ?>:</strong>
                    <div class="text-gray-500">
                        <?php echo $bazaarItem["name"]; ?>
                    </div>
                </div>
                <div>
                    <strong class="text-gray-950"><?php e__("Amount") ?>:</strong>
                    <div class="text-gray-500">
                        <?php echo $bazaarItem["amount"]; ?>
                    </div>
                </div>
                <div>
                    <strong class="text-gray-950"><?php e__("Durability") ?>:</strong>
                    <div class="text-gray-500">
                        <?php echo ($bazaarItem["durability"] > $bazaarItem["maxDurability"] ? $bazaarItem["maxDurability"] : $bazaarItem["durability"]) . "/" . $bazaarItem["maxDurability"]; ?>
                    </div>
                </div>
                <div>
                    <strong class="text-gray-950"><?php e__("Server") ?>:</strong>
                    <div class="text-gray-500">
                        <?php echo $bazaarItem["serverName"]; ?>
                    </div>
                </div>
                <?php if ($bazaarItem["lore"] != null && $bazaarItem["lore"] != ""): ?>
                    <div>
                        <strong class="text-gray-950"><?php e__("Lore") ?>:</strong>
                        <div class="text-gray-500">
                            <?php echo str_replace("\n", "<br>", $bazaarItem["lore"]); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if ($bazaarItem["enchantments"] != null && $bazaarItem["enchantments"] != ""): ?>
                    <div>
                        <strong class="text-gray-950"><?php e__("Enchantments") ?>:</strong>
                        <div class="text-gray-500">
                            <?php
                            $enchantments = $bazaarItem["enchantments"];
                            $enchantments = explode(",", $enchantments);
                            foreach ($enchantments as $enchantment) {
                                $enchantment = explode(":", $enchantment);
                                echo "- Lvl. " . $enchantment[1] . " - " . $enchantment[0] . "<br>";
                            }
                            ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-span-2">
            <div class="card p-6 mt-10">
                <form class="grid gap-4" action="<?php echo url('dashboard.bazaar.update', ['id' => $bazaarItem["id"]]) ?>" method="post">
                    <?php _method('PATCH') ?>
                    <div>
                        <label for="userID" class="form-label">
                            <?php e__('Seller') ?>
                        </label>
		                    <?php $this->insert('components/search-user', [
			                    'userID' => $bazaarItem["owner"]
		                    ]); ?>
                    </div>

                    <div>
                        <label for="price" class="form-label">
                            <?php e__('Price') ?>
                        </label>
                        <input value="<?php _old('price', $bazaarItem['price'] != 0 ? $bazaarItem['price'] : null); ?>" type="text" name="price" id="price" class="form-control">
                    </div>

                    <div>
                        <label for="description" class="form-label">
                            <?php e__('Description') ?>
                        </label>
                        <textarea name="description" id="description" class="form-control"><?php _old('description', $bazaarItem['description']) ?></textarea>
                    </div>

                    <div class="flex justify-end">
                        <?php _csrf(); ?>
                        <button type="submit" name="updateGames" class="btn btn-success">
                            <?php e__('Save Changes') ?>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>