<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.bazaar.index',
        'text' => t__('Bazaar')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Bazaar Items'),
    'category' => 'misc.bazaar.items',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($bazaarItems) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Bazaar Items') ?>
            </h1>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.bazaar.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Bazaar Items')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th style="width: 40px">
							    <?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('Server') ?>
						    </th>
						    <th>
							    <?php e__('Item') ?>
						    </th>
						    <th>
							    <?php e__('Price') ?>
						    </th>
						    <th>
							    <?php e__('Status') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($bazaarItems as $bazaarItem): ?>
						    <tr>
							    <td>
								    <div>#<?php echo $bazaarItem['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $bazaarItem['owner']]) ?>"><?php echo $bazaarItem['realname'] ?></a>
								    <div>@<?php echo $bazaarItem['username'] ?></div>
							    </td>
							    <td>
								    <?php echo $bazaarItem['serverName'] ?>
							    </td>
							    <td>
								    <?php echo $bazaarItem['name'] ?>
							    </td>
							    <td>
								    <?php echo $bazaarItem["price"] == 0 ? t__("Not for sale!") : credits($bazaarItem["price"]); ?>
							    </td>
							    <td class="not">
								    <?php if ($bazaarItem["sold"] == 0): ?>
									    <?php if ($bazaarItem["price"] == 0): ?>
										    <span class="badge badge-warning"><?php e__("In Storage") ?></span>
									    <?php else: ?>
										    <span class="badge badge-success"><?php e__("For sale") ?></span>
									    <?php endif; ?>
								    <?php else: ?>
									    <span class="badge badge-danger"><?php e__("Sold") ?></span>
								    <?php endif; ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($bazaarItem["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($bazaarItem["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.bazaar.edit', ['id' => $bazaarItem['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No bazaar items found!'),
            'details' => t__('There are no bazaar items yet.')
        ]);
    endif; ?>
</section>
