<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.bazaar.index',
        'text' => t__('Bazaar')
    ],
    [
        'text' => t__('Bazaar Logs')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Bazaar Logs'),
    'category' => 'logs.bazaar',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($bazaarLogs) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Bazaar Logs') ?>
            </h1>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.bazaar.logs.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Bazaar Logs')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th style="width: 40px;">
							    <?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('Item') ?>
						    </th>
						    <th>
							    <?php e__('Price') ?>
						    </th>
						    <th class="!text-center">
							    <?php e__('Status') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($bazaarLogs as $bazaarLog): ?>
						    <tr>
							    <td>
								    <div>#<?php echo $bazaarLog['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $bazaarLog['accountID']]) ?>"><?php echo $bazaarLog['realname'] ?></a>
								    <div>@<?php echo $bazaarLog['username'] ?></div>
							    </td>
							    <td class="not">
								    <a href="<?php echo url('dashboard.bazaar.edit', ['id' => $bazaarLog['itemID']]) ?>">
									    <?php echo $bazaarLog['itemName'] ?>
								    </a>
							    </td>
							    <td>
								    <?php echo $bazaarLog['itemPrice'] ?>
							    </td>
							    <td>
								    <div class="flex justify-center items-center">
									    <?php if ($bazaarLog["type"] == 0): ?>
										    <span class="text-danger flex items-center" x-bind="tooltip('<?php e__("Purchase") ?>')">-<i class="w-4" data-feather="coin"></i></span>
									    <?php elseif ($bazaarLog["type"] == 1): ?>
										    <span class="text-success flex items-center" x-bind="tooltip('<?php e__("Sell") ?>')">+<i class="w-4" data-feather="coin"></i></span>
									    <?php else: ?>
										    <span class="text-danger flex items-center" x-bind="tooltip('<?php e__("Error") ?>')">-<i class="w-4" data-feather="close"></i></span>
									    <?php endif; ?>
								    </div>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($bazaarLog["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($bazaarLog["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <form action="<?php echo url('dashboard.bazaar.logs.destroy', ['id' => $bazaarLog['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No bazaar logs found!'),
            'details' => t__('There are no bazaar logs to show here.')
        ]);
    endif; ?>
</section>
