<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.bazaar.index',
        'text' => t__('Bazaar')
    ],
    [
        'url' => 'dashboard.bazaar.servers.index',
        'text' => t__('Servers')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $server['name']]),
    'category' => 'misc.bazaar.servers',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $server['name']]) ?>
        </h1>
        <a href="<?php echo url('dashboard.bazaar.servers.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form class="grid gap-4" action="<?php echo url('dashboard.bazaar.servers.update', ['id' => $server["id"]]) ?>" method="post" enctype="multipart/form-data">
            <?php _method('PATCH') ?>
            <div>
                <label for="name" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input value="<?php _old('name', $server['name']) ?>" type="text" name="name" id="name" class="form-control">
            </div>

            <div>
                <label for="priority" class="form-label">
                    <?php e__('Priority') ?>
                </label>
                <input value="<?php _old('priority', $server['priority']) ?>" type="text" name="priority" id="priority" class="form-control">
            </div>

            <div x-data="image">
                <label for="picture" class="form-label">
                    <?php e__('Image') ?>
                </label>
                <div class="mt-2 image-group" x-bind="imageContainer">
                    <img x-show="imagePreview === null" src="<?php echo '/assets/core/images/bazaar/' . $server['imageID'] . '.' . $server['imageType'] ?>" alt="">
                    <img x-show="imagePreview !== null" :src="imagePreview" alt="">
                    <span>
                      <?php e__('Select an image') ?>
                    </span>
                    <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                </div>
            </div>

            <div>
              <?php $this->insert('components/toggle', [
                'name' => 'isActive',
                'default' => old('isActive', $server['isActive']),
                'labelRight' => t__('Is active?')
              ]); ?>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" name="updateGames" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>