<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.blog.posts.index',
        'text' => t__('Blog')
    ],
    [
        'url' => 'dashboard.blog.comments.index',
        'text' => t__('Comments')
    ],
    [
        'text' => t__('View')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('View Comment'),
    'category' => 'content-management.blog.comments',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('View Comment') ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/blog/comments" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.blog.comments.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="grid">
        <div class="mt-10 card">
            <div class="py-4 px-6 flex justify-between items-center">
                <div class="card-title"><?php echo substr($comment["newsTitle"], 0, 30); ?></div>
                <div class="flex gap-2 items-center">
                    <span class="badge badge-primary" x-bind="tooltip('<?php e__('Date') ?>')"><?php echo convertTime($comment["creationDate"]); ?></span>
                    <?php if ($comment["status"] == 0): ?>
                        <span class="badge badge-danger" x-bind="tooltip('<?php e__('Status') ?>')"><?php e__('Unconfirmed') ?></span>
                    <?php else: ?>
                        <span class="badge badge-success" x-bind="tooltip('<?php e__('Status') ?>')"><?php e__('Confirmed') ?></span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="flex items-start gap-3 px-8 py-4 transition hover:bg-gray-50">
		            <?php $this->insert('components/avatar', [
			            'avatar' => $comment['avatar'],
			            'username' => $comment['realname'],
			            'class' => 'rounded-lg',
			            'size' => '36px'
		            ]); ?>
                <div class="w-full">
                    <div class="flex items-center justify-between font-medium text-gray-800">
	                    <div class="flex flex-col leading-none mt-1">
		                    <span><?php echo $comment["realname"] ?></span>
		                    <span class="text-gray-500 text-xs font-normal">@<?php echo $comment["username"] ?></span>
	                    </div>
	                    <small class="text-xs text-gray-400/75"><?php echo convertTime($comment["creationDate"]); ?></small>
                    </div>
                    <p class="text-sm text-gray-500 mt-2"><?php echo $comment["message"]; ?></p>
                </div>
            </div>
            <div class="mt-10 flex justify-end gap-2 items-center px-6 pb-4">
                <form action="<?php echo url('dashboard.blog.comments.destroy', ['id' => $comment['id']]) ?>" method="post" x-data="deleteConfirmation()">
                    <?php _method('DELETE'); ?>
                    <?php _csrf(); ?>
                    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
                        <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
                    </button>
                </form>
                <form action="<?php echo url('dashboard.blog.comments.update', ['id' => $comment['id']]) ?>" method="post" class="flex gap-2 items-center">
                    <?php _method('PATCH');
                    _csrf(); ?>
                    <a class="btn btn-sm btn-icon btn-primary" target="_blank" x-bind="tooltip('<?php e__('View') ?>')" href="/blog/posts/<?php echo $comment['postSlug'] ?>">
                        <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
                    </a>
                    <?php if ($comment["status"] == 0): ?>
                        <button type="submit" class="btn btn-success"><?php e__('Approve') ?></button>
                    <?php else: ?>
                        <button type="submit" class="btn btn-warning"><?php e__('Decline') ?></button>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
</section>