<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.blog.posts.index',
        'text' => t__('Blog')
    ],
    [
        'text' => t__('Comments')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Comments'),
    'category' => 'content-management.blog.comments',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($comments) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Comments') ?>
            </h1>
		        <div class="flex gap-2">
			        <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/blog/comments" class="btn btn-dark" target="_blank">
				        <?php e__('Help') ?>
			        </a>
		        </div>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.blog.comments.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Comments')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th style="width: 40px">
							    <?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('Author') ?>
						    </th>
						    <th>
							    <?php e__('Message') ?>
						    </th>
						    <th>
							    <?php e__('Status') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($comments as $comment): ?>
						    <tr>
							    <td>
								    <div>#<?php echo $comment['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $comment['accountID']]) ?>"><?php echo $comment['realname'] ?></a>
								    <div>@<?php echo $comment['username'] ?></div>
							    </td>
							    <td>
								    <?php echo substr($comment["message"], 0, 30) ?>
							    </td>
							    <td class="not">
								    <?php if ($comment["status"] == 0): ?>
									    <span class="badge badge-danger"><?php e__('Unconfirmed') ?></span>
								    <?php else: ?>
									    <span class="badge badge-success"><?php e__('Confirmed') ?></span>
								    <?php endif; ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($comment["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($comment["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="/blog/posts/<?php echo $comment['postSlug'] ?>" target="_blank" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <a href="<?php echo url('dashboard.blog.comments.edit', ['id' => $comment['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.blog.comments.destroy', ['id' => $comment['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No comments found!'),
            'details' => t__('There are no comments to show you right now.')
        ]);
    endif; ?>
</section>
