<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.blog.posts.index',
        'text' => t__('Blog')
    ],
    [
        'url' => 'dashboard.blog.posts.index',
        'text' => t__('Posts')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Post'),
    'category' => 'content-management.blog.posts',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Post') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/blog/posts" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.blog.posts.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form x-data="{ isLoading: false }" action="<?php echo url('dashboard.blog.posts.create') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input type="text" id="title" name="title" class="form-control" value="<?php _old('title') ?>">
            </div>
            <div>
                <label for="categoryID" class="form-label">
                    <?php e__('Category') ?>
                </label>
                <select x-data="select2Alpine()" name="categoryID" id="categoryID">
                    <?php if (count($categories) > 0): ?>
                      <?php foreach ($categories as $category): ?>
                        <option value="<?php echo $category["id"] ?>" <?php _selected(old('categoryID') == $category["id"]); ?>>
	                        <?php echo $category["name"] ?>
                        </option>
                      <?php endforeach; ?>
                    <?php else: ?>
                      <option value=""><?php e__('No data found!') ?></option>
                    <?php endif; ?>
                </select>
            </div>
            <div x-data="textEditor()">
                <label for="content" class="form-label">
                    <?php e__('Content') ?>
                </label>
                <div x-data="textEditor()" class="mt-2 relative">
                    <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="content" id="content"><?php _old('content') ?></textarea>
		                <?php $this->insert('components/ai/generate-button', [
			                'target' => '#content',
			                'type' => 'blog_post',
		                ]) ?>
                </div>
            </div>
		        <div>
			        <?php $this->insert('components/toggle', [
				        'name' => 'commentsStatus',
				        'default' => old('commentsStatus', '1'),
				        'labelRight' => t__('Allow Comments')
			        ]); ?>
		        </div>
            <div x-data="tagInput(<?php echo old('tags') !== null ? htmlentities(json_encode(explode(',', old('tags')))) : null; ?>)">
                <label for="tags" class="form-label">
                    <?php e__('Tags') ?>
                </label>
                <template x-if="warning">
                    <span class="text-red-500 text-sm block mb-1"><?php e__('The tag must contain a minimum of 3 characters and a maximum of 60 characters.') ?></span>
                </template>
                <input type="hidden" name="tags" x-model="tags">
                <input x-bind="tagInput" type="text" id="tags" class="form-control" placeholder="<?php e__('Press enter to add a tag.') ?>">
                <div class="flex gap-3 flex-wrap items-center mt-2">
                    <template x-for="(tag, index) in tags">
                        <span @click="tags.splice(index, 1)" class="cursor-pointer badge badge-secondary hover:bg-red-500/20 hover:text-red-500 transition" x-text="tag"></span>
                    </template>
                </div>
            </div>
            <div x-data="image">
                <label for="picture" class="form-label">
                    <?php e__('Image') ?>
                </label>
                <div class="mt-2 image-group" x-bind="imageContainer">
                    <img x-show="imagePreview !== null" :src="imagePreview" alt="">
                    <span>
                      <?php e__('Select an image') ?>
                    </span>
                    <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                </div>
            </div>

            <div class="flex justify-end gap-2">
                <?php _csrf(); ?>
		            <button type="submit" class="btn btn-default" name="status" value="draft" @click="isLoading = true" :class="isLoading ? 'pointer-events-none opacity-50' : ''">
			            <?php e__('Save Draft') ?>
		            </button>
                <button type="submit" class="btn btn-success" name="status" value="published" @click="isLoading = true" :class="isLoading ? 'pointer-events-none opacity-50' : ''">
                    <?php e__('Publish') ?>
                </button>
            </div>
        </form>
    </div>
</section>