<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.blog.posts.index',
        'text' => t__('Blog')
    ],
    [
        'url' => 'dashboard.blog.posts.index',
        'text' => t__('Posts')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $post['title']]),
    'category' => 'content-management.blog.posts',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $post['title']]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="/blog/posts/<?php echo $post["slug"]; ?>" class="btn btn-primary" target="_blank">
				    <?php e__('View') ?>
			    </a>
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/blog/posts" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.blog.posts.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form x-data="{ isLoading: false }" action="<?php echo url('dashboard.blog.posts.update', ['id' => $post['id']]) ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
            <?php _method('PATCH'); ?>
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('title', $post['title']) ?>" type="text" name="title" id="title" class="form-control">
            </div>
            <div>
                <label for="category" class="form-label">
                    <?php e__('Category') ?>
                </label>
                <select x-data="select2Alpine()" name="categoryID" id="categoryID">
                    <?php if (count($categories) > 0): ?>
                        <?php foreach ($categories as $category): ?>
                            <option value="<?php echo $category["id"] ?>" <?php _selected(old('categoryID', $post["categoryID"]) == $category["id"]); ?>>
	                            <?php echo $category["name"] ?>
                            </option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value=""><?php e__('No data found!') ?></option>
                    <?php endif; ?>
                </select>
            </div>
            <div x-data="textEditor()">
                <label for="content" class="form-label">
                    <?php e__('Content') ?>
                </label>
                <div x-data="textEditor()" class="mt-2 relative">
                    <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="content" id="content"><?php _old('content', $post['content']) ?></textarea>
		                <?php $this->insert('components/ai/generate-button', [
			                'target' => '#content',
			                'type' => 'blog_post',
		                ]) ?>
                </div>
            </div>
		        <div>
			        <?php $this->insert('components/toggle', [
				        'name' => 'commentsStatus',
				        'default' => old('commentsStatus', $post["commentsStatus"]),
				        'labelRight' => t__('Allow Comments')
			        ]); ?>
		        </div>
            <div x-data="tagInput(<?php echo htmlentities(json_encode(old('tags') != null ? explode(',', old('tags')) : $post['tags'])) ?>)">
                <label for="tags" class="form-label">
                    <?php e__('Tags') ?>
                </label>
                <template x-if="warning">
                    <span class="text-red-500 text-sm block mb-1"><?php e__('The tag must contain a minimum of 3 characters and a maximum of 60 characters.') ?></span>
                </template>
                <input type="hidden" name="tags" x-model="tags">
                <input x-bind="tagInput" type="text" id="tags" class="form-control" placeholder="<?php e__('Press enter to add a tag.') ?>">
                <div class="flex gap-3 flex-wrap items-center mt-2">
                    <template x-for="(tag, index) in tags">
                        <span @click="tags.splice(index, 1)" class="cursor-pointer badge badge-secondary hover:bg-red-500/20 hover:text-red-500 transition" x-text="tag"></span>
                    </template>
                </div>
            </div>
            <div x-data="image">
                <label for="picture" class="form-label">
                    <?php e__('Image') ?>
                </label>
                <div class="mt-2 image-group" x-bind="imageContainer">
		                <?php if ($post['imageID'] != "" && $post['imageType'] != ""): ?>
	                    <img x-show="imagePreview === null" src="<?php echo '/assets/core/images/blog/posts/' . $post['imageID'] . '.' . $post['imageType'] ?>" alt="">
		                <?php endif; ?>
                    <img x-show="imagePreview !== null" :src="imagePreview" alt="">
                    <span>
                      <?php e__('Select an image') ?>
                    </span>
                    <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                </div>
            </div>
	        
		        <div class="flex justify-end gap-2">
			        <?php _csrf(); ?>
			        <?php if ($post["status"] == "draft"): ?>
				        <button type="submit" class="btn btn-default" name="status" value="draft" @click="isLoading = true" :class="isLoading ? 'pointer-events-none opacity-50' : ''">
				          <?php e__('Save Draft') ?>
				        </button>
			        <?php else: ?>
				        <button type="submit" class="btn btn-default" name="status" value="draft" @click="if (confirm('<?php e__('Are you sure you want to unpublish this post?') ?>')) { isLoading = true; } else { $event.preventDefault(); }" :class="isLoading ? 'pointer-events-none opacity-50' : ''">
				          <?php e__('Switch to Draft') ?>
				        </button>
			        <?php endif; ?>
			        <button type="submit" class="btn btn-success" name="status" value="published" @click="isLoading = true" :class="isLoading ? 'pointer-events-none opacity-50' : ''">
				        <?php if ($post["status"] == "draft"): ?>
				          <?php e__('Publish') ?>
				        <?php else: ?>
					        <?php e__('Save Changes') ?>
				        <?php endif; ?>
			        </button>
		        </div>
        </form>
    </div>
</section>