<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.blog.posts.index',
        'text' => t__('Blog')
    ],
    [
        'text' => t__('Posts')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Blog Posts'),
    'category' => 'content-management.blog.posts',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($posts) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Blog Posts') ?>
            </h1>
            <a href="<?php echo url('dashboard.blog.posts.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.blog.posts.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Blog Posts')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <?php e__('Title') ?>/<?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('Author') ?>
						    </th>
						    <th>
							    <?php e__('Category') ?>
						    </th>
						    <th class="!text-center">
							    <?php e__('Views') ?>
						    </th>
						    <th>
							    <?php e__('Comments') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($posts as $post): ?>
						    <tr>
							    <td>
								    <div>
									    <a href="<?php echo url('dashboard.blog.posts.edit', ['id' => $post["id"]]) ?>"><?php echo $post['title'] ?></a>
									    <?php if ($post["status"] == "draft"): ?>
									      <span class="text-sm text-gray-400"> — <?php e__('Draft') ?></span>
									    <?php endif; ?>
								    </div>
								    <div>#<?php echo $post['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $post['accountID']]) ?>"><?php echo $post['realname'] ?></a>
								    <div>@<?php echo $post['username'] ?></div>
							    </td>
							    <td class="not">
								    <a href="<?php echo url('dashboard.blog.categories.edit', ['id' => $post["categoryID"]]) ?>">
									    <?php echo $post['categoryName'] ?>
								    </a>
							    </td>
							    <td class="center">
								    <div><?php echo $post['views'] ?></div>
								    <div><?php e__('Times Viewed') ?></div>
							    </td>
							    <td>
								    <?php echo $post['commentsCount'] ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($post["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($post["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="/blog/posts/<?php echo $post["slug"]; ?>" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary" target="_blank">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <a href="<?php echo url('dashboard.blog.posts.edit', ['id' => $post["id"]]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.blog.posts.destroy', ['id' => $post["id"]]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button type="submit" class="btn btn-sm btn-icon btn-danger" x-bind="tooltip('<?php e__('Delete') ?>')">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No blog posts found!'),
            'details' => t__('You can add a new blog post by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.blog.posts.create',
                'text' => t__('Create Blog Post')
            ],
        ]);
    endif; ?>
</section>
