<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.changelog.index',
        'text' => t__('Changelog')
    ],
    [
        'url' => 'dashboard.changelog.create',
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Changelog'),
		'category' => 'content-management.changelog',
    'breadcrumbs' => $breadcrumbs
]) ?>

<style>
	.ck-editor__editable[role=textbox] {
		min-height: 50px;
	}
</style>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Changelog') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/changelog" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.changelog.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

		<form method="post" action="<?php echo url('dashboard.changelog.store') ?>" class="mt-10 grid gap-6">
				<div class="card p-6 grid gap-4">
			    <div>
				    <label for="title" class="form-label">
					    <?php e__('Title') ?>
				    </label>
				    <input value="<?php _old('title') ?>" type="text" id="title" name="title" class="form-control" required>
			    </div>
		    </div>
			
				<div>
					<?php
						$defaultInputs = array_map(function($tags, $items) {
							return [
								'tags' => $tags,
								'items' => $items,
							];
						}, old('tags', []), old('items', []));
					?>
					<div x-data="inputArray({
	            tags: '',
	            items: ''
	          }, <?php echo htmlentities(json_encode($defaultInputs)) ?>)"
					>
						<div class="card p-6">
							<div class="flex justify-between items-center mb-4">
								<div class="card-title">
									<?php e__('Content') ?>
								</div>
								<span @click="addInput()" class="btn btn-sm btn-sheer btn-primary cursor-pointer flex items-center justify-center gap-1">
									<i data-feather="add" class="w-4 h-4 -ml-1"></i>
									<?php e__('Add') ?>
								</span>
							</div>
							
							<div x-data="sortable()">
								<template x-for="(input, index) in inputs" :key="index">
									<div class="card p-6 mb-3 !bg-[#f8f8f8] dark:!bg-[#16161b] relative">
										<div class="grid gap-4">
											<div class="">
												<label class="form-label">
													<?php e__('Tag') ?>:
												</label>
												<select name="tags[]" class="form-control" x-model="input.tags">
													<?php foreach ($tags as $tag): ?>
														<option value="<?php echo $tag["id"] ?>" :selected="input.tags === '<?php echo $tag["id"] ?>'">
															<?php echo $tag["name"] ?>
														</option>
													<?php endforeach; ?>
												</select>
											</div>
											<div class="">
												<label class="form-label">
													<?php e__('Content') ?>:
												</label>
												<div x-data="textEditor()">
													<textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="items[]" x-text="input.items"></textarea>
												</div>
											</div>
											<div class="absolute right-2 top-2 flex gap-1">
												<div class="btn btn-icon btn-secondary draggable-item">
													<i data-feather="move" class="w-5 h-5"></i>
												</div>
												<div @click="deleteInput(index)" class="btn btn-icon btn-danger">
													<i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
												</div>
											</div>
										</div>
									</div>
								</template>
							</div>
						</div>
						
					</div>
					
					<!--
					<div x-data="inputArray({
	            tags: '',
	            items: ''
	          }, <?php echo htmlentities(json_encode($defaultInputs)) ?>)"
					>
						<div class="flex justify-between items-center">
							<div class="card-title">
								<?php e__('Content') ?>
							</div>
							<span @click="addInput()" class="btn btn-sm btn-sheer btn-primary cursor-pointer flex items-center justify-center gap-1">
								<i data-feather="add" class="w-4 h-4 -ml-1"></i>
								<?php e__('Add') ?>
							</span>
						</div>
						<table class="mt-3 table">
							<colgroup>
								<col style="width: 20%;">
								<col style="width: 80%;">
							</colgroup>
							<thead class="">
							<tr class="table-header !text-xs !text-gray-500">
								<th scope="col" class="!text-left">
									<?php e__('Tag') ?>
								</th>
								<th scope="col" class="!text-left">
									<?php e__('Content') ?>
								</th>
								<th scope="col" style="width: 40px">
									<span class="sr-only">
										<?php e__('Actions') ?>
									</span>
								</th>
							</tr>
							</thead>
							<tbody x-data="sortable()" class="divide-y divide-gray-200/20 text-center">
							<template x-for="(input, index) in inputs" :key="index">
								<tr>
									<td class="!text-left !pl-0">
										<select name="tags[]" class="form-control" x-model="input.tags">
											<?php foreach ($tags as $tag): ?>
												<option value="<?php echo $tag["id"] ?>" :selected="input.tags === '<?php echo $tag["id"] ?>'">
													<?php echo $tag["name"] ?>
												</option>
											<?php endforeach; ?>
										</select>
									</td>
									<td class="!text-left !pl-0">
										<div x-data="textEditor()">
											<textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="items[]" x-text="input.items"></textarea>
										</div>
									</td>
									<td class="justify-end flex items-center !px-0 gap-1" style="width: 80px; margin-top: 5px;">
										<div class="btn btn-icon btn-secondary draggable-item">
											<i data-feather="move" class="w-5 h-5"></i>
										</div>
										<div @click="deleteInput(index)" class="btn btn-icon btn-danger">
											<i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
										</div>
									</td>
								</tr>
							</template>
							</tbody>
						</table>
					</div>
					-->
				</div>
			
				<div class="flex justify-end">
					<?php _csrf(); ?>
					<button type="submit" class="btn btn-success">
						<?php e__('Create') ?>
					</button>
				</div>
		</form>
</section>
