<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.changelog.index',
        'text' => t__('Changelog')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Changelog'),
		'category' => 'content-management.changelog',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($changelogs) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Changelog') ?>
            </h1>
            <a href="<?php echo url('dashboard.changelog.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Changelog')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="title">
								    <?php e__('Title') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="date">
								    <?php e__('Date') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($changelogs as $changelog): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.changelog.edit', ['id' => $changelog['id']]) ?>" class="title"><?php echo $changelog['title'] ?></a>
								    <div>#<?php echo $changelog['id'] ?></div>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($changelog["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($changelog["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="/changelog/<?php echo $changelog['id'] ?>" target="_blank" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <a href="<?php echo url('dashboard.changelog.edit', ['id' => $changelog['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.changelog.destroy', ['id' => $changelog['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No changelog found!'),
            'details' => t__('You can create a new changelog by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.changelog.create',
                'text' => t__('Create Changelog')
            ]
        ]);
    endif; ?>
</section>
