<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.changelog.tags.index',
        'text' => t__('Tags')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Tag'),
		'category' => 'content-management.changelog.tags',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('styles') ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/codemirror.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/theme/material-ocean.min.css"/>
<style>
    .CodeMirror-gutter .CodeMirror-linenumbers {
        width: 29px !important
    }

    .CodeMirror-gutter-wrapper {
        left: -30px !important
    }

    .CodeMirror-sizer {
        margin-left: 30px !important;
        margin-bottom: -16px !important;
        border-right-width: 14px !important;
        min-height: 160px !important;
        min-width: 78.5px !important;
        padding-right: 0px !important;
        padding-bottom: 0px !important;
    }
</style>
<?php $this->end();
$this->push('scripts') ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/codemirror.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/mode/css/css.min.js"></script>
<?php $this->end() ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Tag') ?></h1>
        <a href="<?php echo url('dashboard.changelog.tags.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.changelog.tags.create') ?>" method="post" class="grid gap-4">
            <div>
                <label for="name" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input value="<?php _old('name') ?>" type="text" id="name" name="name" class="form-control">
            </div>
            <div x-data="codeMirror()">
                <label for="badgeCSS" class="form-label">
                    <?php e__('Badge CSS') ?>
                </label>
                <textarea x-ref="editor" id="badgeCSS" class="form-control" name="badgeCSS"><?php _old('badgeCSS') ?></textarea>
            </div>
            
            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>

