<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.changelog.tags.index',
        'text' => t__('Tags')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Tags'),
		'category' => 'content-management.changelog.tags',
    'breadcrumbs' => $breadcrumbs
]) ?>


<section class="los-container py-9">
    <?php if (count($tags) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Tags') ?>
            </h1>
            <a href="<?php echo url('dashboard.changelog.tags.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>

        <?php _message(); ?>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Tags')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="name">
								    <?php e__('Name') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($tags as $tag): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.changelog.tags.edit', ['id' => $tag['id']])?>" class="name"><?php echo $tag['name'] ?></a>
								    <div>#<?php echo $tag['id'] ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.changelog.tags.edit', ['id' => $tag['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.changelog.tags.destroy', ['id' => $tag['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No tag found!'),
            'details' => t__('You can create a new tag by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.changelog.tags.create',
                'text' => t__('Create Tag')
            ],
        ]);
    endif; ?>

</section>
