<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.custom-fields.index',
        'text' => t__('Custom Fields')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Custom Field'),
    'category' => 'user-management.custom-fields',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Custom Field') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/custom-profile-fields" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.custom-fields.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.custom-fields.create') ?>" method="post" class="grid gap-4">
            <div>
                <label for="name" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input value="<?php _old('name') ?>" type="text" id="name" name="name" class="form-control">
            </div>
            <div>
                <label for="description" class="form-label">
                    <?php e__('Description') ?>
                </label>
                <textarea name="description" id="description" cols="30" rows="4" class="form-control"><?php _old('description') ?></textarea>
            </div>
            <div>
                <label for="type" class="form-label">
                    <?php e__('Type') ?>
                </label>
                <select x-data="select2Alpine()" name="type" id="type">
                    <option value="1" <?php echo (old('type') == 1) ? 'selected="selected"' : null; ?>><?php e__('Text') ?></option>
                    <option value="2" <?php echo (old('type') == 1) ? 'selected="selected"' : null; ?>><?php e__('Number') ?></option>
                </select>
            </div>

            <div>
                <?php $this->insert('components/toggle', [
                  'name' => 'isPublic',
                  'default' => old('isPublic', '1'),
                  'labelRight' => t__('Is public?'),
                ]); ?>
            </div>
            <div>
                <?php $this->insert('components/toggle', [
                  'name' => 'isRequired',
                  'default' => old('isRequired', '0'),
                  'labelRight' => t__('Is required?'),
                ]); ?>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>

