<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.custom-fields.index',
        'text' => t__('Custom Fields')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $customField['name']]),
    'category' => 'user-management.custom-fields',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $customField['name']]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/custom-profile-fields" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.custom-fields.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.custom-fields.updaye', ['id' => $customField['id']]) ?>" method="post" class="grid gap-4">
            <?php _method('PATCH'); ?>
            <div>
                <label for="name" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input value="<?php _old('name', $customField['name']) ?>" type="text" id="name" name="name" class="form-control">
            </div>
            <div>
                <label for="description" class="form-label">
                    <?php e__('Description') ?>
                </label>
                <textarea name="description" id="description" cols="30" rows="4" class="form-control"><?php _old('description', $customField['description']) ?></textarea>
            </div>
            <div>
                <label for="type" class="form-label">
                    <?php e__('Type') ?>
                </label>
                <select x-data="select2Alpine()" name="type" id="type">
                    <option value="1" <?php _selected(old('type', $customField["type"]) == 1); ?>><?php e__('Text') ?></option>
                    <option value="2" <?php _selected(old('type', $customField["type"]) == 2); ?>><?php e__('Number') ?></option>
                </select>
            </div>

            <div>
                <?php $this->insert('components/toggle', [
                  'name' => 'isPublic',
                  'default' => old('isPublic', $customField['isPublic']),
                  'labelRight' => t__('Is public?'),
                ]); ?>
            </div>
            <div>
                <?php $this->insert('components/toggle', [
                  'name' => 'isRequired',
                  'default' => old('isRequired', $customField['isRequired']),
                  'labelRight' => t__('Is required?'),
                ]); ?>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>

