<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.custom-fields.index',
        'text' => t__('Custom Fields')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Custom Fields'),
    'category' => 'user-management.custom-fields',
    'breadcrumbs' => $breadcrumbs
]) ?>


<section class="los-container py-9">
    <?php if (count($customFields) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Custom Fields') ?>
            </h1>
            <a href="<?php echo url('dashboard.custom-fields.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Custom Fields')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="name">
								    <?php e__('Name') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="type">
								    <?php e__('Type') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="isRequired">
								    <?php e__('Required') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="isPublic">
								    <?php e__('Public') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($customFields as $customField): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.custom-fields.edit', ['id' => $customField['id']]) ?>" class="name"><?php echo $customField['name'] ?></a>
								    <div>#<?php echo $customField['id'] ?></div>
							    </td>
							    <td class="type">
								    <?php
									    if ($customField["type"] == 1) {
										    e__('Text');
									    } elseif ($customField["type"] == 2) {
										    e__('Number');
									    }
								    ?>
							    </td>
							    <td class="isRequired not">
								    <?php if ($customField["isRequired"]): ?>
									    <span class="badge badge-success"><?php e__('Yes') ?></span>
								    <?php else: ?>
									    <span class="badge badge-danger"><?php e__('No') ?></span>
								    <?php endif; ?>
							    </td>
							    <td class="isPublic not">
								    <?php if ($customField["isPublic"]): ?>
									    <span class="badge badge-success"><?php e__('Yes') ?></span>
								    <?php else: ?>
									    <span class="badge badge-danger"><?php e__('No') ?></span>
								    <?php endif; ?>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.custom-fields.edit', ['id' => $customField['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.custom-fields.destroy', ['id' => $customField['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No custom fields found!'),
            'details' => t__('You can create a new custom field by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.custom-fields.create',
                'text' => t__('Create Custom Field')
            ],
        ]);
    endif; ?>
</section>
