<?php
$breadcrumbs = [
	[
		'url' => 'dashboard.settings.index',
		'text' => t__('Settings')
	],
	[
		'url' => 'dashboard.discord-webhooks.index',
		'text' => t__('Discord Webhooks')
	],
  [
    'text' => t__('Edit')
  ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $discordWebhook['name']]),
		'category' => 'settings.webhooks',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('styles') ?>
<link rel="stylesheet" href="<?php echo $this->asset('/libs/discord-webhook-builder/css/builder.css') ?>">

<script src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/10.4.1/highlight.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/twemoji@14.0.2/dist/twemoji.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/codemirror.min.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/addon/scroll/simplescrollbars.min.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/codemirror.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/addon/scroll/simplescrollbars.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/mode/javascript/javascript.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/theme/material-darker.min.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/addon/edit/matchbrackets.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/addon/fold/brace-fold.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/addon/fold/foldgutter.min.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/addon/fold/foldgutter.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/addon/fold/foldcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/addon/lint/json-lint.min.js"></script>
<script src="https://unpkg.com/jsonlint@1.6.3/web/jsonlint.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/addon/lint/lint.min.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/addon/lint/lint.min.js"></script>

<script src="<?php echo $this->asset('/libs/discord-webhook-builder/js/components.js') ?>"></script>
<script src="<?php echo $this->asset('/libs/discord-webhook-builder/js/builder.config.js') ?>"></script>
<script src="<?php echo $this->asset('/libs/discord-webhook-builder/js/script.js') ?>" defer></script>
<?php $this->end(); ?>

<?php $this->push('scripts') ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/codemirror.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/mode/javascript/javascript.min.js"></script>
<script>
	$('#discordWebhookBuilderForm').on('keyup keypress', function(e) {
		var keyCode = e.keyCode || e.which;
		if (keyCode === 13 && e.target.tagName === 'INPUT') {
			e.preventDefault();
			return false;
		}
	});
</script>
<?php $this->end() ?>

<section
	class="py-9 los-container tight-container"
	x-data="{
		showVariables: false,
		event: '<?php echo _old('event', $discordWebhook["event"]) ?>',
		init() {
			document.querySelector('HTML').addEventListener('keydown', (event) => {
				const keyCode = event.keyCode || event.which
				
				if (keyCode === 27 && this.showVariables !== false) this.showVariables = false;
			})
		}
	}"
>
		<div x-show="showVariables !== false" class="fixed inset-0" style="z-index: 99;">
			<div @click="showVariables = false" class="absolute inset-0 bg-black/50 backdrop-blur-[1px]"></div>
			<div class="max-w-xl w-full card p-3 absolute-center -mt-20 duration-200 transition relative"
			     x-transition:enter-start="opacity-0 scale-90"
			     x-transition:enter-end="opacity-100 scale-100"
			     x-transition:leave-start="opacity-100 scale-100"
			     x-transition:leave-end="opacity-0 scale-90">
				<div class="py-4 px-6 flex justify-between items-center">
					<div class="text-los font-medium font-maven text-xl"><?php e__('Variables') ?></div>
					<div @click="showVariables = false" class="cursor-pointer text-sm text-gray-400/75 transition hover:text-gray-400">
						<svg class="w-4 fill-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
							<path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"></path>
						</svg>
					</div>
				</div>
				<div class="py-4 px-6 grid gap-4">
					<div x-show="event === ''" class="text-red-500">
						<?php e__('Please select an event to see variables.') ?>
					</div>
					<?php foreach ($events as $event): ?>
						<div x-show="event === '<?php echo $event["value"]; ?>'">
							<div class="mb-6">
								<div class="text-gray-950 font-medium"><?php echo $event["name"] ?></div>
								<div class="text-gray-500 text-sm"><?php echo $event["description"] ?></div>
							</div>
							
							<table class="table">
								<thead>
								<tr class="table-header dark:!bg-black">
									<th class="text-left"><?php e__('Variable') ?></th>
									<th class="text-left"><?php e__('Replaces with') ?></th>
								</tr>
								</thead>
								<tbody>
								<?php foreach ($event["variables"] as $variable => $variableDescription): ?>
									<tr>
										<td class="text-gray-950"><?php echo $variable ?></td>
										<td class="text-gray-400"><?php echo $variableDescription ?></td>
									</tr>
								<?php endforeach; ?>
								</tbody>
							</table>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		</div>
	
	
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $discordWebhook['name']]) ?>
        </h1>
	      <div class="flex gap-2">
		      <a href="<?php echo leaderosHelpUrl() ?>/modules/discord-webhooks" class="btn btn-dark" target="_blank">
			      <?php e__('Help') ?>
		      </a>
	        <a href="<?php echo url('dashboard.discord-webhooks.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
	      </div>
    </div>

    <?php _message(); ?>
	
	<form method="post" action="<?php echo url('dashboard.discord-webhooks.update', ['id' => $discordWebhook['id']]) ?>" class="mt-10 grid gap-6">
		<?php _method('PATCH') ?>
		
		<div class="card p-6 grid gap-4">
			<div>
				<label for="name" class="form-label">
					<?php e__('Name') ?>
				</label>
				<input value="<?php _old('name', $discordWebhook["name"]) ?>" type="text" id="name" name="name" class="form-control" required>
			</div>
			<div>
				<label for="url" class="form-label">
					<?php e__('URL') ?>
				</label>
				<input value="<?php _old('url', $discordWebhook["url"]) ?>" type="text" id="url" name="url" class="form-control" required>
			</div>
			<div>
				<?php $this->insert('components/toggle', [
					'name' => 'isActive',
					'default' => old('isActive', $discordWebhook['isActive']),
					'labelRight' => t__('Is active?')
				]); ?>
			</div>
			<div>
				<label for="event" class="form-label">
					<?php e__('Event') ?>
				</label>
				<fieldset>
					<legend class="sr-only"><?php e__('Event') ?></legend>
					<div class="space-y-5">
						<?php foreach ($events as $event): ?>
							<div class="relative flex items-start" @click="document.getElementById('event_<?php echo $event["value"]; ?>').checked = true; event = '<?php echo $event["value"]; ?>'">
								<div class="flex items-center h-5">
									<input id="event_<?php echo $event["value"]; ?>" name="event" value="<?php echo $event["value"]; ?>" type="radio" class="form-radio" <?php _checked(old('event', $discordWebhook["event"]) == $event["value"]); ?>>
								</div>
								<div class="ml-3 text-sm">
									<label for="event_<?php echo $event["value"]; ?>" class="font-medium text-gray-700 cursor-pointer">
										<?php echo $event["name"] ?>
									</label>
									<p id="small-description" class="text-gray-500 cursor-pointer">
										<?php echo $event["description"] ?>
									</p>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</fieldset>
			</div>
		</div>
		<div class="card p-6 grid gap-4">
			<div>
				<label for="botName" class="form-label">
					<?php e__('Bot Name') ?>
				</label>
				<input value="<?php _old('botName', $discordWebhook["botName"]) ?>" type="text" id="botName" name="botName" class="form-control" required>
			</div>
			<div>
				<label for="botAvatar" class="form-label">
					<?php e__('Bot Avatar') ?>
				</label>
				<input value="<?php _old('botAvatar', $discordWebhook["botAvatar"]) ?>" type="text" id="botAvatar" name="botAvatar" class="form-control" required>
			</div>
		</div>
		<div class="grid grid-cols-1 lg:grid-cols-2 gap-4 discord-webhook-builder">
			<div class="card" id="discordWebhookTabs" data-mode="gui">
				<div class="tab-container !flex-row !p-4">
					<div class="tab-item opt gui active">
						<?php e__('Editor') ?>
					</div>
					<div class="tab-item opt json">
						<?php e__('JSON') ?>
					</div>
					<div @click="showVariables = true" class="btn btn-default !ml-auto">
						<?php e__('Show Variables') ?>
					</div>
				</div>
				<div class="p-6">
					<div>
						<section id="discordWebhookBuilderForm" class="side1" style="max-height: 500px; overflow: scroll;">
							<div class="top item">
								<div id="guiItems" class="gui">
									<div class="item content active" style="margin-top: 0;">
										<p class="ttle">Message content</p>
									</div>
									<div class="edit">
										<textarea class="editContent" placeholder="Message content" maxlength="2000" autocomplete="off"></textarea>
									</div>
									<div class="item guiEmbedName ">
										<span class="text">Embed 1</span>
										<span class="icon">
											<svg version="1.1" x="0" y="0" viewBox="0 0 24 24" width="16" height="16">
												<g>
													<g>
														<path d="m7 7v12c0 .5522847.44771525 1 1 1h8c.5522847 0 1-.4477153 1-1v-12zm-1-2h12c.5522847 0 1 .44771525 1 1v13c0 1.6568542-1.3431458 3-3 3h-8c-1.65685425 0-3-1.3431458-3-3v-13c0-.55228475.44771525-1 1-1z" class="fill-black dark:fill-white"></path>
														<path d="m4 7c-.55228475 0-1-.44771525-1-1s.44771525-1 1-1h16c.5522847 0 1 .44771525 1 1s-.4477153 1-1 1z" class="fill-black dark:fill-white"></path>
														<path d="m10 4c-.55228475 0-1-.44771525-1-1s.44771525-1 1-1h4c.5522847 0 1 .44771525 1 1s-.4477153 1-1 1z" class="fill-black dark:fill-white"></path>
														<path d="m9 10c0-.55228475.44771525-1 1-1 .5522847 0 1 .44771525 1 1v6c0 .5522847-.4477153 1-1 1-.55228475 0-1-.4477153-1-1z" class="fill-black dark:fill-white"></path>
														<path d="m13 10c0-.55228475.4477153-1 1-1s1 .44771525 1 1v6c0 .5522847-.4477153 1-1 1s-1-.4477153-1-1z" class="fill-black dark:fill-white"></path>
													</g>
												</g>
											</svg>
										</span>
									</div>
									<div class="guiEmbed">
										<div class="item color active">
											<p class="ttle">Color</p>
										</div>
										<div class="edit">
											<div class="coloris-container square">
												<input
													type="text"
													class="colorPicker coloris"
													x-data="{
															  init() {
															      this.$nextTick(() => {
															          Coloris({
															              el: '.coloris',
															              theme: 'pill',
															              alpha: false,
															              themeMode: 'light',
															              formatToggle: false,
															              closeButton: false,
															              clearButton: true,
															              swatches: [
															                  '#067bc2',
															                  '#84bcda',
															                  '#80e377',
															                  '#ecc30b',
															                  '#f37748',
															                  '#d56062'
															              ],
															              onChange: (color) => {
															                  handleColorChange(this.$el, color);
															              }
															          });
															      })
															  }
															}"
													value="#000000"
													style="margin-left: 0;"
												>
											</div>
										</div>
										<div class="item author rows2 active">
											<p class="ttle">Author</p>
										</div>
										<div class="edit">
											<div class="linkName">
												<div class="editIcon">
													<span class="imgParent"></span>
													<input class="editAuthorLink" type="text" placeholder="Icon URL" autocomplete="off">
												</div>
												<div class="editName">
													<input class="editAuthorName" type="text" maxlength="256" placeholder="Author name" autocomplete="off">
												</div>
											</div>
											<div class="browse">
												<svg version="1.1" width="512" height="512" x="0" y="0" viewBox="0 0 64 64">
													<g>
														<path d="m23.414 21.414 6.586-6.586v29.172c0 1.104.896 2 2 2s2-.896 2-2v-29.172l6.586 6.586c.39.391.902.586 1.414.586s1.024-.195 1.414-.586c.781-.781.781-2.047 0-2.828l-10-10c-.78-.781-2.048-.781-2.828 0l-10 10c-.781.781-.781 2.047 0 2.828.78.781 2.048.781 2.828 0z" class="fill-black dark:fill-white"></path>
														<path d="m50 40c-1.104 0-2 .896-2 2v8c0 1.103-.897 2-2 2h-28c-1.103 0-2-.897-2-2v-8c0-1.104-.896-2-2-2s-2 .896-2 2v8c0 3.309 2.691 6 6 6h28c3.309 0 6-2.691 6-6v-8c0-1.104-.896-2-2-2z" class="fill-black dark:fill-white"></path>
													</g>
												</svg>
												<svg version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0">
													<circle class="fill-black dark:fill-white" stroke="none" cx="6" cy="50" r="6">
														<animateTransform attributeName="transform" dur="1s" type="translate" values="0 15 ; 0 -15; 0 15" repeatCount="indefinite" begin="0.1"></animateTransform>
													</circle>
													<circle class="fill-black dark:fill-white" stroke="none" cx="30" cy="50" r="6">
														<animateTransform attributeName="transform" dur="1s" type="translate" values="0 10 ; 0 -10; 0 10" repeatCount="indefinite" begin="0.2"></animateTransform>
													</circle>
													<circle class="fill-black dark:fill-white" stroke="none" cx="54" cy="50" r="6">
														<animateTransform attributeName="transform" dur="1s" type="translate" values="0 5 ; 0 -5; 0 5" repeatCount="indefinite" begin="0.3"></animateTransform>
													</circle>
												</svg>
												<p></p>
											</div>
										</div>
										<div class="item title active">
											<p class="ttle">Title</p>
										</div>
										<div class="edit">
											<input class="editTitle" type="text" placeholder="Title" autocomplete="off" maxlength="256" style="margin-left: 0; width: 100%">
										</div>
										<div class="item description active">
											<p class="ttle">Description</p>
										</div>
										<div class="edit">
											<textarea class="editDescription" placeholder="Embed description" maxlength="2048" autocomplete="off"></textarea>
										</div>
										<div class="item fields">
											<p class="ttle">Fields</p>
										</div>
										<div class="edit">
											<div class="fields">
												<div class="field">
													<div class="fieldNumber"></div>
													<div class="fieldInner">
														<div class="designerFieldName">
															<input type="text" placeholder="Field name" value="Field name" autocomplete="off" maxlength="256">
														</div>
														<div class="designerFieldValue">
															<textarea placeholder="Field value" autocomplete="off" maxlength="1024">Field value</textarea>
														</div>
													</div>
													<div class="flex items-center">
														<div class="inlineCheck">
															<label>
																<input type="checkbox" class="form-checkbox" autocomplete="off">
																<span>Inline</span>
															</label>
														</div>
														<div class="removeBtn">
															<svg version="1.1" width="512" height="512" x="0" y="0" viewBox="0 0 329.26933 329">
																<g>
																	<path d="m194.800781 164.769531 128.210938-128.214843c8.34375-8.339844 8.34375-21.824219 0-30.164063-8.339844-8.339844-21.824219-8.339844-30.164063 0l-128.214844 128.214844-128.210937-128.214844c-8.34375-8.339844-21.824219-8.339844-30.164063 0-8.34375 8.339844-8.34375 21.824219 0 30.164063l128.210938 128.214843-128.210938 128.214844c-8.34375 8.339844-8.34375 21.824219 0 30.164063 4.15625 4.160156 9.621094 6.25 15.082032 6.25 5.460937 0 10.921875-2.089844 15.082031-6.25l128.210937-128.214844 128.214844 128.214844c4.160156 4.160156 9.621094 6.25 15.082032 6.25 5.460937 0 10.921874-2.089844 15.082031-6.25 8.34375-8.339844 8.34375-21.824219 0-30.164063zm0 0" class="fill-black dark:fill-white" data-original="#000000"></path>
																</g>
															</svg>
															<span>Remove</span>
														</div>
													</div>
												</div>
											</div>
											<div class="addField">
												<p>New Field</p>
												<svg version="1.1" x="0" y="0" viewBox="0 0 477.867 477.867">
													<g>
														<g>
															<g>
																<path d="M392.533,0h-307.2C38.228,0.056,0.056,38.228,0,85.333v307.2c0.056,47.105,38.228,85.277,85.333,85.333h307.2    c47.105-0.056,85.277-38.228,85.333-85.333v-307.2C477.81,38.228,439.638,0.056,392.533,0z M443.733,392.533    c0,28.277-22.923,51.2-51.2,51.2h-307.2c-28.277,0-51.2-22.923-51.2-51.2v-307.2c0-28.277,22.923-51.2,51.2-51.2h307.2    c28.277,0,51.2,22.923,51.2,51.2V392.533z" class="fill-black dark:fill-white" data-original="#000000"></path>
															</g>
														</g>
														<g>
															<g>
																<path d="M324.267,221.867H256V153.6c0-9.426-7.641-17.067-17.067-17.067s-17.067,7.641-17.067,17.067v68.267H153.6    c-9.426,0-17.067,7.641-17.067,17.067S144.174,256,153.6,256h68.267v68.267c0,9.426,7.641,17.067,17.067,17.067    S256,333.692,256,324.267V256h68.267c9.426,0,17.067-7.641,17.067-17.067S333.692,221.867,324.267,221.867z" class="fill-black dark:fill-white" data-original="#000000"></path>
															</g>
														</g>
														<g></g>
														<g></g>
														<g></g>
														<g></g>
														<g></g>
														<g></g>
														<g></g>
														<g></g>
														<g></g>
														<g></g>
														<g></g>
														<g></g>
														<g></g>
														<g></g>
														<g></g>
													</g>
												</svg>
											</div>
										</div>
										<div class="item thumbnail largeImg">
											<p class="ttle">Thumbnail</p>
										</div>
										<div class="edit">
											<div class="linkName">
												<div class="editIcon">
													<span class="imgParent"></span>
													<div class="txtCol">
														<input class="editThumbnailLink" type="text" placeholder="Thumbnail URL" autocomplete="off">
														<div class="browse">
															<svg version="1.1" width="512" height="512" x="0" y="0" viewBox="0 0 64 64">
																<g>
																	<path d="m23.414 21.414 6.586-6.586v29.172c0 1.104.896 2 2 2s2-.896 2-2v-29.172l6.586 6.586c.39.391.902.586 1.414.586s1.024-.195 1.414-.586c.781-.781.781-2.047 0-2.828l-10-10c-.78-.781-2.048-.781-2.828 0l-10 10c-.781.781-.781 2.047 0 2.828.78.781 2.048.781 2.828 0z" class="fill-black dark:fill-white" data-original="#000000"></path>
																	<path d="m50 40c-1.104 0-2 .896-2 2v8c0 1.103-.897 2-2 2h-28c-1.103 0-2-.897-2-2v-8c0-1.104-.896-2-2-2s-2 .896-2 2v8c0 3.309 2.691 6 6 6h28c3.309 0 6-2.691 6-6v-8c0-1.104-.896-2-2-2z" class="fill-black dark:fill-white" data-original="#000000"></path>
																</g>
															</svg>
															<svg version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0">
																<circle fill="#fff" stroke="none" cx="6" cy="50" r="6">
																	<animateTransform attributeName="transform" dur="1s" type="translate" values="0 15 ; 0 -15; 0 15" repeatCount="indefinite" begin="0.1"></animateTransform>
																</circle>
																<circle fill="#fff" stroke="none" cx="30" cy="50" r="6">
																	<animateTransform attributeName="transform" dur="1s" type="translate" values="0 10 ; 0 -10; 0 10" repeatCount="indefinite" begin="0.2"></animateTransform>
																</circle>
																<circle fill="#fff" stroke="none" cx="54" cy="50" r="6">
																	<animateTransform attributeName="transform" dur="1s" type="translate" values="0 5 ; 0 -5; 0 5" repeatCount="indefinite" begin="0.3"></animateTransform>
																</circle>
															</svg>
															<p></p>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="item image largeImg">
											<p class="ttle">Image</p>
										</div>
										<div class="edit">
											<div class="linkName">
												<div class="editIcon">
													<span class="imgParent"></span>
													<div class="txtCol">
														<input class="editImageLink" type="text" placeholder="Image URL" autocomplete="off">
														<div class="browse">
															<svg version="1.1" width="512" height="512" x="0" y="0" viewBox="0 0 64 64">
																<g>
																	<path d="m23.414 21.414 6.586-6.586v29.172c0 1.104.896 2 2 2s2-.896 2-2v-29.172l6.586 6.586c.39.391.902.586 1.414.586s1.024-.195 1.414-.586c.781-.781.781-2.047 0-2.828l-10-10c-.78-.781-2.048-.781-2.828 0l-10 10c-.781.781-.781 2.047 0 2.828.78.781 2.048.781 2.828 0z" class="fill-black dark:fill-white" data-original="#000000"></path>
																	<path d="m50 40c-1.104 0-2 .896-2 2v8c0 1.103-.897 2-2 2h-28c-1.103 0-2-.897-2-2v-8c0-1.104-.896-2-2-2s-2 .896-2 2v8c0 3.309 2.691 6 6 6h28c3.309 0 6-2.691 6-6v-8c0-1.104-.896-2-2-2z" class="fill-black dark:fill-white" data-original="#000000"></path>
																</g>
															</svg>
															<svg version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0">
																<circle fill="#fff" stroke="none" cx="6" cy="50" r="6">
																	<animateTransform attributeName="transform" dur="1s" type="translate" values="0 15 ; 0 -15; 0 15" repeatCount="indefinite" begin="0.1"></animateTransform>
																</circle>
																<circle fill="#fff" stroke="none" cx="30" cy="50" r="6">
																	<animateTransform attributeName="transform" dur="1s" type="translate" values="0 10 ; 0 -10; 0 10" repeatCount="indefinite" begin="0.2"></animateTransform>
																</circle>
																<circle fill="#fff" stroke="none" cx="54" cy="50" r="6">
																	<animateTransform attributeName="transform" dur="1s" type="translate" values="0 5 ; 0 -5; 0 5" repeatCount="indefinite" begin="0.3"></animateTransform>
																</circle>
															</svg>
															<p></p>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="item footer rows2">
											<p class="ttle">Footer</p>
										</div>
										<div class="edit">
											<div class="linkName">
												<div class="editIcon">
													<span class="imgParent"></span>
													<input class="editFooterLink" type="text" placeholder="Icon URL" autocomplete="off">
												</div>
												<div class="editName">
													<input class="editFooterText" type="text" maxlength="2048" value="Footer text" placeholder="Footer text" autocomplete="off">
												</div>
											</div>
											<div class="browse">
												<svg version="1.1" width="512" height="512" x="0" y="0" viewBox="0 0 64 64">
													<g>
														<path d="m23.414 21.414 6.586-6.586v29.172c0 1.104.896 2 2 2s2-.896 2-2v-29.172l6.586 6.586c.39.391.902.586 1.414.586s1.024-.195 1.414-.586c.781-.781.781-2.047 0-2.828l-10-10c-.78-.781-2.048-.781-2.828 0l-10 10c-.781.781-.781 2.047 0 2.828.78.781 2.048.781 2.828 0z" class="fill-black dark:fill-white" data-original="#000000"></path>
														<path d="m50 40c-1.104 0-2 .896-2 2v8c0 1.103-.897 2-2 2h-28c-1.103 0-2-.897-2-2v-8c0-1.104-.896-2-2-2s-2 .896-2 2v8c0 3.309 2.691 6 6 6h28c3.309 0 6-2.691 6-6v-8c0-1.104-.896-2-2-2z" class="fill-black dark:fill-white" data-original="#000000"></path>
													</g>
												</svg>
												<svg version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0">
													<circle fill="#fff" stroke="none" cx="6" cy="50" r="6">
														<animateTransform attributeName="transform" dur="1s" type="translate" values="0 15 ; 0 -15; 0 15" repeatCount="indefinite" begin="0.1"></animateTransform>
													</circle>
													<circle fill="#fff" stroke="none" cx="30" cy="50" r="6">
														<animateTransform attributeName="transform" dur="1s" type="translate" values="0 10 ; 0 -10; 0 10" repeatCount="indefinite" begin="0.2"></animateTransform>
													</circle>
													<circle fill="#fff" stroke="none" cx="54" cy="50" r="6">
														<animateTransform attributeName="transform" dur="1s" type="translate" values="0 5 ; 0 -5; 0 5" repeatCount="indefinite" begin="0.3"></animateTransform>
													</circle>
												</svg>
												<p></p>
											</div>
										</div>
									</div>
									<div class="guiEmbedAdd pointer">
										<div class="icon">
											<svg width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
												<path fill-rule="evenodd" d="M8 2a.5.5 0 0 1 .5.5v5h5a.5.5 0 0 1 0 1h-5v5a.5.5 0 0 1-1 0v-5h-5a.5.5 0 0 1 0-1h5v-5A.5.5 0 0 1 8 2Z"></path>
											</svg>
										</div>
										<div class="text">Add embed</div>
									</div>
								</div>
								<textarea id="editorHolder" name="data"><?php _old('data', $discordWebhook["data"], false) ?></textarea>
							</div>
						</section>
					</div>
				</div>
			</div>
			<section class="side2">
				<div class="msgEmbed-card flex gap-4 rounded-2xl">
					<img src="https://cdn.discordapp.com/embed/avatars/1.png" class="avatar" alt=" " />
					<div class="msgEmbed">
						<div class="contents">
							<h2 class="flex items-center gap-1 mb-2">
								<span class="username" role="button">Discord Bot</span>
								<span class="botTag">
									<svg aria-label="Verified bot" class="botTagVerified" aria-hidden="false" width="16" height="16" viewBox="0 0 16 15.2">
										<path d="M7.4,11.17,4,8.62,5,7.26l2,1.53L10.64,4l1.36,1Z" fill="currentColor"></path>
									</svg>
									<span class="botText">BOT</span>
								</span>
								<span class="timeText"></span>
							</h2>
						</div>
						<div class="markup messageContent"></div>
						<div class="container">
							<div class="embed markup">
								<div class="embedGrid">
									<div class="embedAuthor embedMargin"></div>
									<div class="embedTitle embedMargin"></div>
									<div class="embedDescription embedMargin"></div>
									<div class="embedFields"></div>
									<div class="imageWrapper clickable embedMedia embedImage">
										<img class="img embedImageLink" onload="this.nextElementSibling?.style.removeProperty('display');"  />
										<div class="spinner-container" style="display: block;">
											<span class="spinner">
												<span class="inner">
													<span class="wanderingCubesItem"></span>
													<span class="wanderingCubesItem"></span>
												</span>
											</span>
										</div>
									</div>
									<div class="imageWrapper clickable embedThumbnail">
										<img class="img embedThumbnailLink" onload="this.nextElementSibling?.style.removeProperty('display');" />
										<div class="spinner-container" style="display: block;">
											<span class="spinner">
												<span class="inner">
													<span class="wanderingCubesItem"></span>
													<span class="wanderingCubesItem"></span>
												</span>
											</span>
										</div>
									</div>
									<div class="embedFooter embedMargin"></div>
								</div>
							</div>
						</div>
						<div class="emptyTxt">Nothing here</div>
					</div>
				</div>
				<div class="bottomSide">
					<div class="notification">There is an error</div>
				</div>
			</section>
		</div>
		
		<div class="flex justify-end gap-2">
			<?php _csrf(); ?>
			<button @click="setEditorContent(); checkWebhook()" type="button" class="btn btn-default flex items-center">
				<svg style="display: none;" class="animate-spin -ml-1 mr-3 h-5 w-5 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
					<circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
					<path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
				</svg>
				<span>
					<?php e__('Send test message') ?>
				</span>
			</button>
			<button type="submit" class="btn btn-success" onclick="setEditorContent()">
				<?php e__('Save Changes') ?>
			</button>
		</div>
	</form>
</section>
