<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'text' => t__('Discord Webhooks')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Discord Webhooks'),
    'category' => 'settings.webhooks',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
	<?php if (count($discordWebhooks) > 0): ?>
		<div class="los-page-heading">
			<h1 class="text-gray-950">
				<?php e__('Discord Webhooks') ?>
			</h1>
			<a href="<?php echo url('dashboard.discord-webhooks.create') ?>" class="btn btn-primary">
				<?php e__('Add New') ?>
			</a>
		</div>
		
		<div x-data="listjs()" id="listjs" class="grid mt-10">
			<div class="los-table-actions mb-4 grid">
				<div class="w-full">
					<label for="search" class="form-label">
						<?php e__('Search for %text%', ['%text%' => t__('Discord Webhooks')]) ?>
					</label>
					<div class="input-absolute-group">
						<i data-feather="search-normal"></i>
						<input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					</div>
				</div>
			</div>
			<div class="los-table">
				<table>
					<thead>
					<tr>
						<th>
							<div class="sort" data-sort="name">
								<?php e__('Name') ?>/<?php e__('ID') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="event">
								<?php e__('Event') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="status">
								<?php e__('Status') ?>
							</div>
						</th>
						<th>
							<span class="sr-only">
								<?php e__('Actions') ?>
							</span>
						</th>
					</tr>
					</thead>
					<tbody class="list">
					<?php foreach ($discordWebhooks as $discordWebhook): ?>
						<tr>
							<td>
								<a href="<?php echo url('dashboard.discord-webhooks.edit', ['id' => $discordWebhook['id']]) ?>" class="name"><?php echo $discordWebhook['name'] ?></a>
								<div>#<?php echo $discordWebhook['id'] ?></div>
							</td>
							<td class="event">
								<?php echo $discordWebhook['eventName'] ?>
							</td>
							<td class="status not">
								<?php if ($discordWebhook["isActive"] == 0): ?>
									<span class="badge badge-soft-danger"><?php e__('Disabled') ?></span>
								<?php else: ?>
									<span class="badge badge-soft-success"><?php e__('Active') ?></span>
								<?php endif; ?>
							</td>
							<td class="table-action-buttons">
								<a href="<?php echo url('dashboard.discord-webhooks.edit', ['id' => $discordWebhook['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									<i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								</a>
								<form action="<?php echo url('dashboard.discord-webhooks.destroy', ['id' => $discordWebhook['id']]) ?>" method="post" x-data="deleteConfirmation()">
									<?php _method('DELETE'); ?>
									<?php _csrf(); ?>
									<button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										<i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									</button>
								</form>
							</td>
						</tr>
					<?php endforeach; ?>
					</tbody>
				</table>
			</div>
		</div>
	<?php else:
		$this->insert('components/empty', [
			'title' => t__('No webhooks found!'),
			'details' => t__('You can create a new webhook by clicking the button below.'),
			'button' => [
				'url' => 'dashboard.discord-webhooks.create',
				'text' => t__('Create Webhook')
			]
		]);
	endif; ?>
</section>