<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.downloads.index',
        'text' => t__('Files')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create File'),
    'category' => 'misc.downloads',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Create File') ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/download-center" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.downloads.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.downloads.create') ?>" method="post" class="grid gap-4">
            <div>
                <label for="file_name" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input value="<?php _old('url_name') ?>" type="text" id="file_name" name="name" class="form-control">
            </div>
            <div>
                <label for="url" class="form-label">
                    <?php e__('Download URL') ?>
                </label>
                <input value="<?php _old('url') ?>" type="text" id="url" name="downloadURL" class="form-control">
            </div>
            <div x-data="textEditor()">
                <label for="content" class="form-label">
                    <?php e__('Description') ?>
                </label>
                <div x-data="textEditor()" class="mt-2">
                    <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="content" id="content">
                        <?php _old('content') ?>
                    </textarea>
                </div>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" name="insertDownloads" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>
