<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.failed-jobs.index',
        'text' => t__('Failed Jobs')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Failed Jobs'),
    'category' => 'logs.failed-jobs',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($failedJobs) > 0): ?>
		    <div class="los-page-heading">
			    <h1 class="text-gray-950">
				    <?php e__('Failed Jobs') ?>
			    </h1>
			    <div class="flex gap-2">
				    <form action="<?php echo url('dashboard.failed-jobs.destroyAll') ?>" method="post" x-data="deleteConfirmation()">
					    <?php _method('DELETE'); ?>
					    <?php _csrf(); ?>
					    <button type="submit" class="btn btn-danger">
						    <?php e__('Delete All') ?>
					    </button>
				    </form>
			    </div>
		    </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.failed-jobs.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Failed Jobs')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <?php e__('Name') ?>/<?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('Error') ?>
						    </th>
						    <th>
							    <?php e__('Retries') ?>
						    </th>
						    <th class="!text-center">
							    <?php e__('Last Retry') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($failedJobs as $job): ?>
						    <tr>
							    <td>
								    <div>
									    <?php echo $job["name"] ?>
								    </div>
								    <div>#<?php echo $job['id'] ?></div>
							    </td>
							    <td>
						        <div style="max-width: 300px; max-height: 100px; overflow: auto; word-break: break-all;">
					            <?php echo htmlspecialchars($job['error']) ?>
						        </div>
							    </td>
							    <td>
								    <?php echo $job['attempts'] . "/" . $job['maxAttempts'] ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($job['lastRetryAt'], 2, true) ?></div>
								    <div><?php echo convertTime($job['lastRetryAt']) ?></div>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($job['createdAt'], 2, true) ?></div>
								    <div><?php echo convertTime($job['createdAt']) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <form action="<?php echo url('dashboard.failed-jobs.destroy', ['id' => $job['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No failed jobs found!'),
            'details' => t__('There are no failed jobs to show you right now.')
        ]);
    endif; ?>
</section>
