<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.forms.index',
        'text' => t__('Custom Forms')
    ],
    [
        'text' => t__('Answers')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Answers'),
    'category' => 'forms.custom-forms.submissions',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($forms) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Answers') ?>
            </h1>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.forms.answers.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Answers')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <?php e__('Form') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($forms as $form): ?>
						    <tr>
							    <td class="not">
								    <a href="<?php echo url('dashboard.forms.edit', ['id' => $form['formID']]) ?>">
									    <?php echo $form['title'] ?>
								    </a>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $form['accountID']]) ?>"><?php echo $form['realname'] ?></a>
								    <div>@<?php echo $form['username'] ?></div>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($form["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($form["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.forms.answers.show', ['id' => $form['id']]) ?>" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No answers found!'),
            'details' => t__('There are no answers to show here.')
        ]);
    endif; ?>
</section>
