<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.forms.index',
        'text' => t__('Custom Forms')
    ],
    [
        'url' => 'dashboard.forms.answers.index',
        'text' => t__('Answers')
    ],
    [
        'text' => t__('View')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('View Form Answer'),
    'category' => 'forms.custom-forms.submissions',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('View Form Answer') ?>
        </h1>
        <a href="<?php echo url('dashboard.forms.answers.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <div class="grid gap-4 mt-10">
      <div class="card">
        <div class="card-title py-4 px-6">
          <?php e__('Details') ?>
        </div>
        <div class="py-4 px-6 grid xl:grid-cols-3 gap-4 text-gray-500 text-sm">
          <div>
            <div class="font-medium text-gray-600">
              <?php e__('User') ?>:
            </div>
            <a href="<?php echo url('dashboard.accounts.show', ['id' => $form['accountID']]) ?>">
              <?php echo $form["realname"]; ?>
            </a>
	          <div class="text-xs">
		          @<?php echo $form["username"]; ?>
	          </div>
          </div>
          <div>
            <div class="font-medium text-gray-600">
              <?php e__("Form") ?>:
            </div>
            <?php echo $form['title'] ?>
          </div>
          <div>
            <div class="font-medium text-gray-600">
              <?php e__("Date") ?>:
            </div>
            <?php echo convertTime($form["creationDate"], 2, true); ?>
          </div>
        </div>
      </div>
      <div class="card">
        <div class="card-title pt-4 px-6"><?php e__('Questions') ?></div>
        <div class="py-4 px-6">
          <?php foreach ($answers as $answer): ?>
            <div class="rounded-xl bg-gray-100 py-3 px-6 mb-3">
              <div class="text-gray-700 font-semibold capitalize">
                <?php echo $answer["question"] ?>
              </div>
              <div class="text-gray-500 text-sm mt-3">
                <?php echo $answer["answer"]; ?>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
</section>
